/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.iam.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.iam.domain.AuthAssumeRole;
import com.huawei.openstack4j.openstack.iam.domain.AuthToken;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="identity")
public class AuthIdentity
implements ModelEntity {
    private static final long serialVersionUID = 2899115558053618996L;
    private List<String> methods;
    private AuthToken token;
    @JsonProperty(value="assume_role")
    private AuthAssumeRole assumeRole;

    public static AuthIdentityBuilder builder() {
        return new AuthIdentityBuilder();
    }

    public AuthIdentityBuilder toBuilder() {
        return new AuthIdentityBuilder().methods(this.methods).token(this.token).assumeRole(this.assumeRole);
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public AuthToken getToken() {
        return this.token;
    }

    public AuthAssumeRole getAssumeRole() {
        return this.assumeRole;
    }

    public String toString() {
        return "AuthIdentity(methods=" + this.getMethods() + ", token=" + this.getToken() + ", assumeRole=" + this.getAssumeRole() + ")";
    }

    public AuthIdentity() {
    }

    @ConstructorProperties(value={"methods", "token", "assumeRole"})
    public AuthIdentity(List<String> methods, AuthToken token, AuthAssumeRole assumeRole) {
        this.methods = methods;
        this.token = token;
        this.assumeRole = assumeRole;
    }

    public static class AuthIdentityBuilder {
        private List<String> methods;
        private AuthToken token;
        private AuthAssumeRole assumeRole;

        AuthIdentityBuilder() {
        }

        public AuthIdentityBuilder methods(List<String> methods) {
            this.methods = methods;
            return this;
        }

        public AuthIdentityBuilder token(AuthToken token) {
            this.token = token;
            return this;
        }

        public AuthIdentityBuilder assumeRole(AuthAssumeRole assumeRole) {
            this.assumeRole = assumeRole;
            return this;
        }

        public AuthIdentity build() {
            return new AuthIdentity(this.methods, this.token, this.assumeRole);
        }

        public String toString() {
            return "AuthIdentity.AuthIdentityBuilder(methods=" + this.methods + ", token=" + this.token + ", assumeRole=" + this.assumeRole + ")";
        }
    }
}

