/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.identity.AuthStore;
import com.huawei.openstack4j.model.identity.AuthVersion;
import com.huawei.openstack4j.openstack.common.Auth;
import com.huawei.openstack4j.openstack.identity.v2.domain.Auth;

@JsonRootName(value="auth")
public class RaxApiKeyCredentials
extends Auth
implements AuthStore {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="RAX-KSKEY:apiKeyCredentials")
    private ApiKeyCredentials apikeyCreds = new ApiKeyCredentials();

    public RaxApiKeyCredentials() {
        super(Auth.Type.RAX_APIKEY);
    }

    public RaxApiKeyCredentials(String username, String apiKey) {
        this();
        this.apikeyCreds.setCredentials(username, apiKey);
    }

    @Override
    @JsonIgnore
    public String getTenantId() {
        return super.getTenantId();
    }

    @Override
    @JsonIgnore
    public String getTenantName() {
        return super.getTenantName();
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.apikeyCreds.username;
    }

    @Override
    @JsonIgnore
    public String getPassword() {
        return this.getApiKey();
    }

    @JsonIgnore
    public String getApiKey() {
        return this.apikeyCreds.apiKey;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getTenantId();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.getTenantName();
    }

    @Override
    @JsonIgnore
    public AuthVersion getVersion() {
        return AuthVersion.V2;
    }

    private static final class ApiKeyCredentials {
        @JsonProperty
        String username;
        @JsonProperty
        String apiKey;

        private ApiKeyCredentials() {
        }

        public void setCredentials(String username, String apiKey) {
            this.username = username;
            this.apiKey = apiKey;
        }
    }
}

