/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v2.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v2.TenantService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v2.Tenant;
import com.huawei.openstack4j.model.identity.v2.TenantUser;
import com.huawei.openstack4j.openstack.identity.v2.domain.KeystoneTenant;
import com.huawei.openstack4j.openstack.identity.v2.domain.KeystoneTenantUser;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class TenantServiceImpl
extends BaseOpenStackService
implements TenantService {
    @Override
    public List<? extends Tenant> list() {
        return this.get(KeystoneTenant.Tenants.class, "/tenants").execute().getList();
    }

    @Override
    public Tenant get(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId);
        return this.get(KeystoneTenant.class, "/tenants", "/", tenantId).execute();
    }

    @Override
    public Tenant getByName(String tenantName) {
        Preconditions.checkNotNull((Object)tenantName);
        return this.get(KeystoneTenant.BackwardsCompatTenants.class, "/tenants").param("name", tenantName).execute().getOneOrNull();
    }

    @Override
    public Tenant create(Tenant tenant) {
        Preconditions.checkNotNull((Object)tenant);
        return this.post(KeystoneTenant.class, "/tenants").entity(tenant).execute();
    }

    @Override
    public ActionResponse delete(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId);
        return this.deleteWithResponse("/tenants", "/", tenantId).execute();
    }

    @Override
    public Tenant update(Tenant tenant) {
        Preconditions.checkNotNull((Object)tenant);
        return this.post(KeystoneTenant.class, this.uri("/tenants/%s", tenant.getId())).entity(tenant).execute();
    }

    @Override
    public List<? extends TenantUser> listUsers(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId);
        return this.get(KeystoneTenantUser.TenantUsers.class, this.uri("/tenants/%s/users", tenantId)).execute().getList();
    }
}

