/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.huawei.openstack4j.model.identity.v3.Domain;
import com.huawei.openstack4j.model.identity.v3.User;
import com.huawei.openstack4j.model.identity.v3.builder.UserBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneDomain;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="user")
public class KeystoneUser
implements User {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private KeystoneDomain domain;
    @JsonProperty(value="domain_id")
    private String domainId;
    private String email;
    private String password;
    private String description;
    @JsonProperty(value="default_project_id")
    private String defaultProjectId;
    private Map<String, String> links;
    private Boolean enabled = true;
    @JsonProperty(value="password_expires_at")
    private String passwordExpiresAt;
    private Map<String, String> extra;
    @JsonProperty(value="pwd_status")
    private Boolean pwdStatus;
    @JsonProperty(value="pwd_strength")
    private String pwdStrength;
    private String mobile;
    private Boolean forceResetPwd;
    @JsonProperty(value="last_project_id")
    private String lastProjectId;

    public static UserBuilder builder() {
        return new UserConcreteBuilder();
    }

    @Override
    public UserBuilder toBuilder() {
        return new UserConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getMobile() {
        return this.mobile;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Boolean getPwdStatus() {
        return this.pwdStatus;
    }

    @Override
    public String getPwdStrength() {
        return this.pwdStrength;
    }

    @Override
    public Boolean getForceResetPwd() {
        return this.forceResetPwd;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public String getDefaultProjectId() {
        return this.defaultProjectId;
    }

    @Override
    public String getLastProjectId() {
        return this.lastProjectId;
    }

    @Override
    public String getPasswordExpiresAt() {
        return this.passwordExpiresAt;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public Map<String, String> getExtra() {
        return this.extra;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("email", (Object)this.email).add("password", (Object)this.password).add("description", (Object)this.description).add("domainId", (Object)this.domainId).add("links", this.links).add("extra", this.extra).add("enabled", (Object)this.enabled).add("defaultProjectId", (Object)this.defaultProjectId).add("passwordExpiresAt", (Object)this.passwordExpiresAt).add("mobile", (Object)this.mobile).add("pwdStatus", (Object)this.pwdStatus).add("pwdStrength", (Object)this.pwdStrength).add("forceResetPwd", (Object)this.forceResetPwd).add("lastProjectId", (Object)this.lastProjectId).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneUser that = (KeystoneUser)KeystoneUser.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal(this.links, that.links) && Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal((Object)this.defaultProjectId, (Object)that.defaultProjectId);
    }

    public static class UserConcreteBuilder
    implements UserBuilder {
        KeystoneUser model;

        UserConcreteBuilder() {
            this(new KeystoneUser());
        }

        UserConcreteBuilder(KeystoneUser model) {
            this.model = model;
        }

        @Override
        public UserBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public User build() {
            return this.model;
        }

        @Override
        public UserBuilder from(User in) {
            if (in != null) {
                this.model = (KeystoneUser)in;
            }
            return this;
        }

        @Override
        public UserBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public UserBuilder defaultProjectId(String defaultProjectId) {
            this.model.defaultProjectId = defaultProjectId;
            return this;
        }

        @Override
        public UserBuilder lastProjectId(String lastProjectId) {
            this.model.lastProjectId = lastProjectId;
            return this;
        }

        @Override
        public UserBuilder domainId(String domainId) {
            this.model.domainId = domainId;
            return this;
        }

        @Override
        public UserBuilder domain(Domain domain) {
            if (domain != null && domain.getId() != null) {
                this.model.domainId = domain.getId();
            }
            return this;
        }

        @Override
        public UserBuilder email(String email) {
            this.model.email = email;
            return this;
        }

        @Override
        public UserBuilder mobile(String mobile) {
            this.model.mobile = mobile;
            return this;
        }

        @Override
        public UserBuilder password(String password) {
            this.model.password = password;
            return this;
        }

        @Override
        public UserBuilder pwdStatus(Boolean pwdStatus) {
            this.model.pwdStatus = pwdStatus;
            return this;
        }

        @Override
        public UserBuilder pwdStrength(String pwdStrength) {
            this.model.pwdStrength = pwdStrength;
            return this;
        }

        @Override
        public UserBuilder passwordExpiresAt(String passwordExpiresAt) {
            this.model.passwordExpiresAt = passwordExpiresAt;
            return this;
        }

        @Override
        public UserBuilder forceResetPwd(Boolean forceResetPwd) {
            this.model.forceResetPwd = forceResetPwd;
            return this;
        }

        @Override
        public UserBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public UserBuilder extra(Map<String, String> extra) {
            this.model.extra = extra;
            return this;
        }

        @Override
        public UserBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public UserBuilder description(String description) {
            this.model.description = description;
            return this;
        }
    }

    public static class Users
    extends ListResult<KeystoneUser> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="users")
        private List<KeystoneUser> list;

        @Override
        public List<KeystoneUser> value() {
            return this.list;
        }
    }
}

