/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="config")
public class PasswordConfig
implements ModelEntity {
    private static final long serialVersionUID = -4887856515000675547L;
    @JsonProperty(value="security_compliance")
    private Map<String, String> securityCompliance;
    @JsonProperty(value="password_regex")
    private String passwordRegex;
    @JsonProperty(value="password_regex_description")
    private String passwordRegexDescription;

    public String getPasswordRegex() {
        if (this.passwordRegex == null) {
            return this.securityCompliance.get("password_regex");
        }
        return this.passwordRegex;
    }

    public String getPasswordRegexDescription() {
        if (this.passwordRegexDescription == null) {
            return this.securityCompliance.get("password_regex_description");
        }
        return this.passwordRegexDescription;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("securityCompliance", this.securityCompliance).add("passwordRegex", (Object)this.passwordRegex).add("passwordRegexDescription", (Object)this.passwordRegexDescription).toString();
    }

    public static PasswordConfigBuilder builder() {
        return new PasswordConfigBuilder();
    }

    public PasswordConfigBuilder toBuilder() {
        return new PasswordConfigBuilder().securityCompliance(this.securityCompliance).passwordRegex(this.passwordRegex).passwordRegexDescription(this.passwordRegexDescription);
    }

    public Map<String, String> getSecurityCompliance() {
        return this.securityCompliance;
    }

    public PasswordConfig() {
    }

    @ConstructorProperties(value={"securityCompliance", "passwordRegex", "passwordRegexDescription"})
    public PasswordConfig(Map<String, String> securityCompliance, String passwordRegex, String passwordRegexDescription) {
        this.securityCompliance = securityCompliance;
        this.passwordRegex = passwordRegex;
        this.passwordRegexDescription = passwordRegexDescription;
    }

    public static class PasswordConfigBuilder {
        private Map<String, String> securityCompliance;
        private String passwordRegex;
        private String passwordRegexDescription;

        PasswordConfigBuilder() {
        }

        public PasswordConfigBuilder securityCompliance(Map<String, String> securityCompliance) {
            this.securityCompliance = securityCompliance;
            return this;
        }

        public PasswordConfigBuilder passwordRegex(String passwordRegex) {
            this.passwordRegex = passwordRegex;
            return this;
        }

        public PasswordConfigBuilder passwordRegexDescription(String passwordRegexDescription) {
            this.passwordRegexDescription = passwordRegexDescription;
            return this;
        }

        public PasswordConfig build() {
            return new PasswordConfig(this.securityCompliance, this.passwordRegex, this.passwordRegexDescription);
        }

        public String toString() {
            return "PasswordConfig.PasswordConfigBuilder(securityCompliance=" + this.securityCompliance + ", passwordRegex=" + this.passwordRegex + ", passwordRegexDescription=" + this.passwordRegexDescription + ")";
        }
    }
}

