/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v3.CredentialService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Credential;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneCredential;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class CredentialServiceImpl
extends BaseOpenStackService
implements CredentialService {
    @Override
    public Credential create(Credential credential) {
        Preconditions.checkNotNull((Object)credential);
        return this.post(KeystoneCredential.class, this.uri("/credentials", new Object[0])).entity(credential).execute();
    }

    @Override
    public Credential create(String blob, String type, String projectId, String userId) {
        Preconditions.checkNotNull((Object)blob);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)userId);
        return this.create((Credential)KeystoneCredential.builder().blob(blob).type(type).projectId(projectId).userId(userId).build());
    }

    @Override
    public Credential get(String credentialId) {
        Preconditions.checkNotNull((Object)credentialId);
        return this.get(KeystoneCredential.class, "/credentials", "/", credentialId).execute();
    }

    @Override
    public Credential update(Credential credential) {
        Preconditions.checkNotNull((Object)credential);
        return this.patch(KeystoneCredential.class, "/credentials", "/", credential.getId()).entity(credential).execute();
    }

    @Override
    public ActionResponse delete(String credentialId) {
        Preconditions.checkNotNull((Object)credentialId);
        return this.deleteWithResponse("/credentials", "/", credentialId).execute();
    }

    @Override
    public List<? extends Credential> list() {
        return this.get(KeystoneCredential.Credentials.class, this.uri("/credentials", new Object[0])).execute().getList();
    }
}

