/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v3.ProjectService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Project;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class ProjectServiceImpl
extends BaseOpenStackService
implements ProjectService {
    @Override
    public Project create(Project project) {
        Preconditions.checkNotNull((Object)project);
        return this.post(KeystoneProject.class, "/projects").entity(project).execute();
    }

    @Override
    public Project create(String domainId, String name, String description, boolean enabled) {
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)description);
        Preconditions.checkNotNull((Object)enabled);
        return this.create((Project)KeystoneProject.builder().domainId(domainId).name(name).description(description).enabled(enabled).build());
    }

    @Override
    public Project create(String domainId, String name, String description) {
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)description);
        return this.create((Project)KeystoneProject.builder().domainId(domainId).name(name).description(description).build());
    }

    @Override
    public Project get(String projectId) {
        Preconditions.checkNotNull((Object)projectId);
        return this.get(KeystoneProject.class, "/projects", "/", projectId).execute();
    }

    @Override
    public List<? extends Project> getByName(String projectName) {
        Preconditions.checkNotNull((Object)projectName);
        return this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).param("name", projectName).execute().getList();
    }

    @Override
    public Project getByName(String projectName, String domainId) {
        Preconditions.checkNotNull((Object)projectName);
        Preconditions.checkNotNull((Object)domainId);
        return (Project)this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).param("name", projectName).param("domain_id", domainId).execute().first();
    }

    @Override
    public Project update(Project project) {
        Preconditions.checkNotNull((Object)project);
        return this.patch(KeystoneProject.class, "/projects", "/", project.getId()).entity(project).execute();
    }

    @Override
    public ActionResponse delete(String projectId) {
        Preconditions.checkNotNull((Object)projectId);
        return this.deleteWithResponse("/projects", "/", projectId).execute();
    }

    @Override
    public List<? extends Project> list() {
        return this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Project> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<KeystoneProject.Projects> flavorInvocation = this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    @Override
    public List<? extends Project> listByObject(Map<String, Object> filteringParams) {
        BaseOpenStackService.Invocation<KeystoneProject.Projects> flavorInvocation = this.get(KeystoneProject.Projects.class, this.uri("/projects", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, Object> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }
}

