/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v3.RegionService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Region;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneRegion;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class RegionServiceImpl
extends BaseOpenStackService
implements RegionService {
    @Override
    public Region create(Region region) {
        Preconditions.checkNotNull((Object)region);
        return this.post(KeystoneRegion.class, this.uri("/regions", new Object[0])).entity(region).execute();
    }

    @Override
    public Region create(String regionId, String description, String parentRegionId) {
        Preconditions.checkNotNull((Object)regionId);
        Preconditions.checkNotNull((Object)description);
        Preconditions.checkNotNull((Object)parentRegionId);
        return this.create((Region)KeystoneRegion.builder().id(regionId).description(description).parentRegionId(parentRegionId).build());
    }

    @Override
    public Region get(String regionId) {
        Preconditions.checkNotNull((Object)regionId);
        return this.get(KeystoneRegion.class, "/regions", "/", regionId).execute();
    }

    @Override
    public Region update(Region region) {
        Preconditions.checkNotNull((Object)region);
        return this.patch(KeystoneRegion.class, "/regions", "/", region.getId()).entity(region).execute();
    }

    @Override
    public ActionResponse delete(String regionId) {
        Preconditions.checkNotNull((Object)regionId);
        return this.deleteWithResponse("/regions", "/", regionId).execute();
    }

    @Override
    public List<? extends Region> list() {
        return this.get(KeystoneRegion.Regions.class, this.uri("/regions", new Object[0])).execute().getList();
    }
}

