/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.image.domain.functions;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.model.image.ContainerFormat;
import com.huawei.openstack4j.model.image.DiskFormat;
import com.huawei.openstack4j.model.image.Image;
import com.huawei.openstack4j.openstack.image.domain.ImageHeader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ImageForUpdateToHeaders
implements Function<Image, Map<String, Object>> {
    private static final ImageForUpdateToHeaders instance = new ImageForUpdateToHeaders();

    private ImageForUpdateToHeaders() {
    }

    public static ImageForUpdateToHeaders instance() {
        return instance;
    }

    @Nullable
    public Map<String, Object> apply(@Nullable Image from) {
        if (from == null) {
            return null;
        }
        HashMap headers = Maps.newHashMap();
        this.addIfNotNull(headers, ImageHeader.ID, from.getId());
        this.addIfNotNull(headers, ImageHeader.NAME, from.getName());
        this.addIfNotNull(headers, ImageHeader.MIN_DISK, from.getMinDisk());
        this.addIfNotNull(headers, ImageHeader.MIN_RAM, from.getMinRam());
        this.addIfNotNull(headers, ImageHeader.OWNER, from.getOwner());
        this.addIfNotNull(headers, ImageHeader.IS_PUBLIC, from.isPublic());
        this.addIfNotNull(headers, ImageHeader.PROTECTED, from.isProtected());
        this.addIfNotNull(headers, ImageHeader.CHECKSUM, from.getChecksum());
        this.addIfNotNull(headers, ImageHeader.SIZE, from.getSize());
        this.addIfNotNull(headers, ImageHeader.STORE, (Object)from.getStoreType());
        this.addIfNotNull(headers, ImageHeader.COPY_FROM, from.getCopyFrom(), false);
        if (from.getContainerFormat() != ContainerFormat.UNRECOGNIZED) {
            headers.put(ImageHeader.CONTAINER_FORMAT.asHeader(), from.getContainerFormat().value());
        }
        if (from.getDiskFormat() != DiskFormat.UNRECOGNIZED) {
            headers.put(ImageHeader.DISK_FORMAT.asHeader(), from.getDiskFormat().value());
        }
        if (from.getProperties() != null) {
            for (String k : from.getProperties().keySet()) {
                headers.put(ImageHeader.PROPERTY.asHeader() + "-" + k, from.getProperties().get(k));
            }
        }
        return headers;
    }

    private void addIfNotNull(Map<String, Object> headers, ImageHeader header, Object value) {
        this.addIfNotNull(headers, header, value, true);
    }

    private void addIfNotNull(Map<String, Object> headers, ImageHeader header, Object value, boolean asHeader) {
        if (value == null) {
            return;
        }
        if (asHeader) {
            headers.put(header.asHeader(), value);
        } else {
            headers.put(header.asGlanceHeader(), value);
        }
    }
}

