/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.ims.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.common.AsyncJobEntity;
import com.huawei.openstack4j.openstack.ims.v1.domain.CopyImageCrossRegion;
import com.huawei.openstack4j.openstack.ims.v1.domain.CopyImageInRegion;
import com.huawei.openstack4j.openstack.ims.v1.domain.ExportImage;
import com.huawei.openstack4j.openstack.ims.v1.domain.ImageCreateByBackup;
import com.huawei.openstack4j.openstack.ims.v1.domain.ImageCreateByInstance;
import com.huawei.openstack4j.openstack.ims.v1.domain.ImageCreateByOBS;
import com.huawei.openstack4j.openstack.ims.v1.domain.RegistImage;
import com.huawei.openstack4j.openstack.ims.v1.internal.BaseImageManagementService;

public class ImageService
extends BaseImageManagementService {
    public String create(ImageCreateByInstance imageCreateByInstance) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByInstance.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByInstance.getInstanceId()) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudimages/wholeimages/action").entity(imageCreateByInstance).execute().getId();
    }

    public String create(ImageCreateByBackup imageCreateByBackup) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByBackup.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByBackup.getBackupId()) ? 1 : 0) != 0, (Object)"parameter `backupId` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudimages/wholeimages/action").entity(imageCreateByBackup).execute().getId();
    }

    public String create(ImageCreateByOBS imageCreateByOBS) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByOBS.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByOBS.getOsType()) ? 1 : 0) != 0, (Object)"parameter `osType` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByOBS.getImageUrl()) ? 1 : 0) != 0, (Object)"parameter `imageUrl` should not be empty");
        Preconditions.checkArgument((null != imageCreateByOBS.getMinDisk() ? 1 : 0) != 0, (Object)"parameter `minDisk` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudimages/dataimages/action").entity(imageCreateByOBS).execute().getId();
    }

    public String regist(RegistImage image, String imageId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)image.getImageUrl()) ? 1 : 0) != 0, (Object)"parameter `imageUrl` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageId) ? 1 : 0) != 0, (Object)"parameter `imageId` should not be empty");
        return this.put(AsyncJobEntity.class, this.uri("/cloudimages/%s/upload", imageId)).entity(image).execute().getId();
    }

    public String export(ExportImage image, String imageId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)image.getBucketUrl()) ? 1 : 0) != 0, (Object)"parameter `bucketUrl` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)image.getFileFormat()) ? 1 : 0) != 0, (Object)"parameter `fileFormat` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageId) ? 1 : 0) != 0, (Object)"parameter `imageId` should not be empty");
        return this.post(AsyncJobEntity.class, this.uri("/cloudimages/%s/file", imageId)).entity(image).execute().getId();
    }

    public String copyInRegion(CopyImageInRegion copyImageInRegion, String imageId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)copyImageInRegion.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageId) ? 1 : 0) != 0, (Object)"parameter `imageId` should not be empty");
        return this.post(AsyncJobEntity.class, this.uri("/cloudimages/%s/copy", imageId)).entity(copyImageInRegion).execute().getId();
    }

    public String copyCrossRegion(CopyImageCrossRegion copyImageCrossRegion, String imageId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)copyImageCrossRegion.getAgencyName()) ? 1 : 0) != 0, (Object)"parameter `agencyName` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)copyImageCrossRegion.getProjectName()) ? 1 : 0) != 0, (Object)"parameter `projectName` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)copyImageCrossRegion.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)copyImageCrossRegion.getRegion()) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageId) ? 1 : 0) != 0, (Object)"parameter `imageId` should not be empty");
        return this.post(AsyncJobEntity.class, this.uri("/cloudimages/%s/cross_region_copy", imageId)).entity(copyImageCrossRegion).execute().getId();
    }
}

