/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.internal;

import com.google.common.base.Function;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.core.transport.HttpMethod;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.internal.MicroVersion;

public abstract class MicroVersionedOpenStackService
extends BaseOpenStackService {
    private final MicroVersion microVersion;

    protected MicroVersionedOpenStackService(MicroVersion microVersion) {
        this.microVersion = microVersion;
    }

    protected MicroVersionedOpenStackService(ServiceType serviceType, MicroVersion microVersion) {
        super(serviceType);
        this.microVersion = microVersion;
    }

    protected MicroVersionedOpenStackService(ServiceType serviceType, MicroVersion microVersion, Function<String, String> endpointFunc) {
        super(serviceType, endpointFunc);
        this.microVersion = microVersion;
    }

    private MicroVersion getMicroVersion() {
        return this.microVersion;
    }

    protected abstract String getApiVersionHeader();

    @Override
    protected <R> BaseOpenStackService.Invocation<R> get(Class<R> returnType, String ... path) {
        return super.get(returnType, path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> post(Class<R> returnType, String ... path) {
        return super.post(returnType, path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> put(Class<R> returnType, String ... path) {
        return super.put(returnType, path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> patch(Class<R> returnType, String ... path) {
        return super.patch(returnType, path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> delete(Class<R> returnType, String ... path) {
        return super.delete(returnType, path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<ActionResponse> deleteWithResponse(String ... path) {
        return super.deleteWithResponse(path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> head(Class<R> returnType, String ... path) {
        return super.head(returnType, path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> request(HttpMethod method, Class<R> returnType, String path) {
        return super.request(method, returnType, path).header(this.getApiVersionHeader(), this.getMicroVersion().toString());
    }
}

