/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.EndpointTokenProvider;
import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.api.artifact.ArtifactService;
import com.huawei.openstack4j.api.barbican.BarbicanService;
import com.huawei.openstack4j.api.client.CloudProvider;
import com.huawei.openstack4j.api.cloudeye.CloudEyeService;
import com.huawei.openstack4j.api.compute.ComputeService;
import com.huawei.openstack4j.api.deh.DehService;
import com.huawei.openstack4j.api.dns.v2.DNSService;
import com.huawei.openstack4j.api.gbp.GbpService;
import com.huawei.openstack4j.api.heat.HeatService;
import com.huawei.openstack4j.api.identity.EndpointURLResolver;
import com.huawei.openstack4j.api.identity.v2.IdentityService;
import com.huawei.openstack4j.api.image.v2.ImageService;
import com.huawei.openstack4j.api.loadbalance.ELBService;
import com.huawei.openstack4j.api.magnum.MagnumService;
import com.huawei.openstack4j.api.manila.ShareService;
import com.huawei.openstack4j.api.map.reduce.MapReduceService;
import com.huawei.openstack4j.api.murano.v1.AppCatalogService;
import com.huawei.openstack4j.api.nat.NatService;
import com.huawei.openstack4j.api.networking.NetworkingService;
import com.huawei.openstack4j.api.scaling.AutoScalingService;
import com.huawei.openstack4j.api.senlin.SenlinService;
import com.huawei.openstack4j.api.storage.BlockStorageService;
import com.huawei.openstack4j.api.storage.ObjectStorageService;
import com.huawei.openstack4j.api.tacker.TackerService;
import com.huawei.openstack4j.api.telemetry.TelemetryService;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.api.workflow.WorkflowService;
import com.huawei.openstack4j.core.transport.Config;
import com.huawei.openstack4j.model.identity.AuthVersion;
import com.huawei.openstack4j.model.identity.URLResolverParams;
import com.huawei.openstack4j.model.identity.v2.Access;
import com.huawei.openstack4j.model.identity.v3.Token;
import com.huawei.openstack4j.openstack.antiddos.internal.AntiDDoSServices;
import com.huawei.openstack4j.openstack.bms.v1.internal.BareMetaService;
import com.huawei.openstack4j.openstack.cdn.v1.internal.CdnServices;
import com.huawei.openstack4j.openstack.cloud.trace.v1.internal.CloudTraceV1Service;
import com.huawei.openstack4j.openstack.cloud.trace.v2.internal.CloudTraceV2Service;
import com.huawei.openstack4j.openstack.csbs.v1.internal.CloudServerBackupService;
import com.huawei.openstack4j.openstack.database.internal.DatabaseServices;
import com.huawei.openstack4j.openstack.dss.v1.internal.DssService;
import com.huawei.openstack4j.openstack.ecs.v1_1.internal.ElasticComputeService;
import com.huawei.openstack4j.openstack.evs.v2_1.internal.ElasticVolumeService;
import com.huawei.openstack4j.openstack.fgs.v1.internal.FunctionGraphService;
import com.huawei.openstack4j.openstack.fgs.v2.internal.FunctionGraphV2Service;
import com.huawei.openstack4j.openstack.iam.internal.IamService;
import com.huawei.openstack4j.openstack.identity.internal.DefaultEndpointURLResolver;
import com.huawei.openstack4j.openstack.identity.v2.functions.ServiceToServiceType;
import com.huawei.openstack4j.openstack.ims.v1.internal.ImageManagementService;
import com.huawei.openstack4j.openstack.kms.internal.KeyManagementService;
import com.huawei.openstack4j.openstack.maas.internal.MaaSService;
import com.huawei.openstack4j.openstack.message.notification.internal.NotificationService;
import com.huawei.openstack4j.openstack.message.queue.internal.MessageQueueAsyncService;
import com.huawei.openstack4j.openstack.message.queue.internal.MessageQueueService;
import com.huawei.openstack4j.openstack.tms.v1.internal.TagManagementService;
import com.huawei.openstack4j.openstack.trove.internal.TroveService;
import com.huawei.openstack4j.openstack.vpc.v1.internal.VirtualPrivateCloudService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OSClientSession<R, T extends OSClient<T>>
implements EndpointTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OSClientSession.class);
    protected static final ThreadLocal<OSClientSession> sessions = new ThreadLocal();
    protected Config config;
    public Facing perspective;
    protected String region;
    public Token token;
    public String reqId;
    protected Set<ServiceType> supports;
    protected CloudProvider provider;
    protected Map<String, ? extends Object> headers;
    protected EndpointURLResolver fallbackEndpointUrlResolver = new DefaultEndpointURLResolver();

    public static OSClientSession getCurrent() {
        return sessions.get();
    }

    public static void setCurrent(OSClientSession session) {
        sessions.set(session);
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }

    @VisibleForTesting
    public R useConfig(Config config) {
        this.config = config;
        return (R)this;
    }

    public boolean supportsReAuthentication() {
        return true;
    }

    public T useRegion(String region) {
        this.region = region;
        return (T)((OSClient)((Object)this));
    }

    public T removeRegion() {
        return this.useRegion(null);
    }

    public Facing getPerspective() {
        return this.perspective;
    }

    public Config getConfig() {
        return this.config;
    }

    public ComputeService compute() {
        return Apis.getComputeServices();
    }

    public NetworkingService networking() {
        return Apis.getNetworkingServices();
    }

    public AutoScalingService autoScaling() {
        return Apis.get(AutoScalingService.class);
    }

    public ELBService loadBalancer() {
        return Apis.get(ELBService.class);
    }

    public CloudTraceV1Service cloudTraceV1() {
        return Apis.get(CloudTraceV1Service.class);
    }

    public CloudTraceV2Service cloudTraceV2() {
        return Apis.get(CloudTraceV2Service.class);
    }

    public KeyManagementService keyManagement() {
        return Apis.get(KeyManagementService.class);
    }

    public AntiDDoSServices antiDDoS() {
        return Apis.get(AntiDDoSServices.class);
    }

    public NotificationService notification() {
        return Apis.get(NotificationService.class);
    }

    public MessageQueueService messageQueue() {
        return Apis.get(MessageQueueService.class);
    }

    public MaaSService maas() {
        return Apis.get(MaaSService.class);
    }

    public DatabaseServices database() {
        return Apis.get(DatabaseServices.class);
    }

    public ArtifactService artifact() {
        return Apis.getArtifactServices();
    }

    public TackerService tacker() {
        return Apis.getTackerServices();
    }

    public com.huawei.openstack4j.api.image.ImageService images() {
        return Apis.getImageService();
    }

    public ImageService imagesV2() {
        return Apis.getImageV2Service();
    }

    public BlockStorageService blockStorage() {
        return Apis.get(BlockStorageService.class);
    }

    public TelemetryService telemetry() {
        return Apis.get(TelemetryService.class);
    }

    public ShareService share() {
        return Apis.get(ShareService.class);
    }

    public HeatService heat() {
        return Apis.getHeatServices();
    }

    public AppCatalogService murano() {
        return Apis.getMuranoServices();
    }

    public MagnumService magnum() {
        return Apis.getMagnumService();
    }

    public SenlinService senlin() {
        return Apis.getSenlinServices();
    }

    public FunctionGraphService functionGraph() {
        return Apis.getFunctionGraphServices();
    }

    public FunctionGraphV2Service functionGraphV2() {
        return Apis.getFunctionGraphV2Services();
    }

    public ObjectStorageService objectStorage() {
        return Apis.get(ObjectStorageService.class);
    }

    public MapReduceService mrs() {
        return Apis.getMapReduceServices();
    }

    public WorkflowService workflow() {
        return Apis.getWorkflowServices();
    }

    public BarbicanService barbican() {
        return Apis.getBarbicanServices();
    }

    public DNSService dns() {
        return Apis.getDNSService();
    }

    public CdnServices cdn() {
        return Apis.get(CdnServices.class);
    }

    public CloudEyeService cloudEye() {
        return Apis.getCloudEyeService();
    }

    public MessageQueueAsyncService messageQueueAsync() {
        return Apis.get(MessageQueueAsyncService.class);
    }

    public T perspective(Facing perspective) {
        this.perspective = perspective;
        return (T)((OSClient)((Object)this));
    }

    public CloudProvider getProvider() {
        return this.provider == null ? CloudProvider.UNKNOWN : this.provider;
    }

    public T headers(Map<String, ? extends Object> headers) {
        this.headers = headers;
        return (T)((OSClient)((Object)this));
    }

    public Map<String, ? extends Object> getHeaders() {
        return this.headers;
    }

    public boolean supportsCompute() {
        return this.getSupportedServices().contains((Object)ServiceType.COMPUTE);
    }

    public boolean supportsIdentity() {
        return this.getSupportedServices().contains((Object)ServiceType.IDENTITY);
    }

    public boolean supportsNetwork() {
        return this.getSupportedServices().contains((Object)ServiceType.NETWORK);
    }

    public boolean supportsImage() {
        return this.getSupportedServices().contains((Object)ServiceType.IMAGE);
    }

    public boolean supportsHeat() {
        return this.getSupportedServices().contains((Object)ServiceType.ORCHESTRATION);
    }

    public boolean supportsMurano() {
        return this.getSupportedServices().contains((Object)ServiceType.APP_CATALOG);
    }

    public boolean supportsBlockStorage() {
        return this.getSupportedServices().contains((Object)ServiceType.BLOCK_STORAGE);
    }

    public boolean supportsObjectStorage() {
        return this.getSupportedServices().contains((Object)ServiceType.OBJECT_STORAGE);
    }

    public boolean supportsTelemetry() {
        return this.getSupportedServices().contains((Object)ServiceType.TELEMETRY);
    }

    public boolean supportsTelemetry_aodh() {
        return this.getSupportedServices().contains((Object)ServiceType.TELEMETRY_AODH);
    }

    public boolean supportsShare() {
        return this.getSupportedServices().contains((Object)ServiceType.SHARE);
    }

    public boolean supportsTrove() {
        return this.getSupportedServices().contains((Object)ServiceType.DATABASE);
    }

    public boolean supportsDNS() {
        return this.getSupportedServices().contains((Object)ServiceType.DNS);
    }

    public Set<ServiceType> getSupportedServices() {
        return null;
    }

    public AuthVersion getAuthVersion() {
        return null;
    }

    public NatService nat() {
        return Apis.getNatServices();
    }

    public DehService deh() {
        return Apis.getDehService();
    }

    public GbpService gbp() {
        return Apis.getGbpServices();
    }

    public TroveService trove() {
        return Apis.getTroveServices();
    }

    public com.huawei.openstack4j.openstack.ecs.v1.internal.ElasticComputeService ecs() {
        return Apis.getElasticComputeService();
    }

    public ElasticComputeService ecsV1_1() {
        return Apis.get(ElasticComputeService.class);
    }

    public TagManagementService tms() {
        return Apis.get(TagManagementService.class);
    }

    public BareMetaService bms() {
        return Apis.get(BareMetaService.class);
    }

    public com.huawei.openstack4j.openstack.evs.v2.internal.ElasticVolumeService evs() {
        return Apis.get(com.huawei.openstack4j.openstack.evs.v2.internal.ElasticVolumeService.class);
    }

    public DssService dss() {
        return Apis.get(DssService.class);
    }

    public ElasticVolumeService evsV2_1() {
        return Apis.get(ElasticVolumeService.class);
    }

    public com.huawei.openstack4j.openstack.vpc.v2.internal.VirtualPrivateCloudService vpcV2() {
        return Apis.get(com.huawei.openstack4j.openstack.vpc.v2.internal.VirtualPrivateCloudService.class);
    }

    public VirtualPrivateCloudService vpc() {
        return Apis.get(VirtualPrivateCloudService.class);
    }

    public com.huawei.openstack4j.openstack.ims.v2.internal.ImageManagementService imsV2() {
        return Apis.get(com.huawei.openstack4j.openstack.ims.v2.internal.ImageManagementService.class);
    }

    public ImageManagementService ims() {
        return Apis.get(ImageManagementService.class);
    }

    public CloudServerBackupService csbs() {
        return Apis.get(CloudServerBackupService.class);
    }

    public IamService iam() {
        return Apis.get(IamService.class);
    }

    public static class OSClientSessionV2
    extends OSClientSession<OSClientSessionV2, OSClient.OSClientV2>
    implements OSClient.OSClientV2 {
        Access access;

        private OSClientSessionV2(Access access, String endpoint, Facing perspective, CloudProvider provider, Config config) {
            this.access = access;
            this.config = config;
            this.perspective = perspective;
            this.provider = provider;
            sessions.set(this);
        }

        private OSClientSessionV2(Access access, OSClientSessionV2 parent, String region) {
            this.access = parent.access;
            this.perspective = parent.perspective;
            this.region = region;
        }

        public static OSClientSessionV2 createSession(Access access) {
            return new OSClientSessionV2(access, access.getEndpoint(), null, null, null);
        }

        public static OSClientSessionV2 createSession(Access access, Facing perspective, CloudProvider provider, Config config) {
            return new OSClientSessionV2(access, access.getEndpoint(), perspective, provider, config);
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getEndpoint() {
            return this.access.getEndpoint();
        }

        @Override
        public AuthVersion getAuthVersion() {
            return AuthVersion.V2;
        }

        private String addNATIfApplicable(String url) {
            if (this.config != null && this.config.isBehindNAT()) {
                try {
                    URI uri = new URI(url);
                    return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
                }
                catch (URISyntaxException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            return url;
        }

        @Override
        public String getEndpoint(ServiceType service) {
            EndpointURLResolver eUrlResolver = this.config != null && this.config.getEndpointURLResolver() != null ? this.config.getEndpointURLResolver() : this.fallbackEndpointUrlResolver;
            return this.addNATIfApplicable(eUrlResolver.findURLV2(URLResolverParams.create(this.access, service).resolver(this.config != null ? this.config.getV2Resolver() : null).perspective(this.perspective).region(this.region)));
        }

        @Override
        public String getTokenId() {
            return this.access.getToken().getId();
        }

        @Override
        public IdentityService identity() {
            return Apis.getIdentityV2Services();
        }

        @Override
        public Set<ServiceType> getSupportedServices() {
            if (this.supports == null) {
                this.supports = Sets.immutableEnumSet((Iterable)Iterables.transform(this.access.getServiceCatalog(), (Function)new ServiceToServiceType()));
            }
            return this.supports;
        }
    }
}

