/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.api.ServiceEndpointProvider;
import com.huawei.openstack4j.api.client.CloudProvider;
import com.huawei.openstack4j.api.exceptions.RegionEndpointNotFoundException;
import com.huawei.openstack4j.api.identity.EndpointURLResolver;
import com.huawei.openstack4j.api.identity.v3.IdentityService;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.model.identity.AuthVersion;
import com.huawei.openstack4j.model.identity.URLResolverParams;
import com.huawei.openstack4j.model.identity.v3.Endpoint;
import com.huawei.openstack4j.model.identity.v3.Service;
import com.huawei.openstack4j.openstack.identity.internal.AKSKEndpointURLResolver;
import com.huawei.openstack4j.openstack.internal.OSClientSession;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSClientSessionAKSK
extends OSClientSession<OSClientSessionAKSK, OSClient.OSClientAKSK>
implements OSClient.OSClientAKSK {
    private String accessKey;
    private String secretKey;
    private String cloudDomainName;
    private String projectId;
    private String domainId;
    private HashMap<ServiceType, ServiceEndpointProvider.ServiceEndpoint> serviceEndpoints;
    private static final Logger LOG = LoggerFactory.getLogger(OSClientSessionAKSK.class);
    CloudProvider provider = CloudProvider.HUAWEI;
    protected EndpointURLResolver defaultEndpointURLResolver = AKSKEndpointURLResolver.instance();

    @Override
    public String getEndpoint() {
        throw new RuntimeException("Token is not required by AKSK-authentication");
    }

    @Override
    public String getEndpoint(ServiceType service) {
        URLResolverParams params = URLResolverParams.create(service).perspective(this.perspective).region(this.region).domain(this.cloudDomainName).projectId(this.projectId).serviceEndpoints(this.serviceEndpoints);
        String url = null;
        try {
            if (this.config != null && this.config.getEndpointURLResolver() != null) {
                url = this.config.getEndpointURLResolver().resolve(params);
                if (url == null) {
                    url = this.defaultEndpointURLResolver.resolve(params);
                }
            } else {
                url = this.defaultEndpointURLResolver.resolve(params);
            }
        }
        catch (NullPointerException e) {
            throw new RegionEndpointNotFoundException("region endpoint can not be found");
        }
        return this.addNATIfApplicable(url);
    }

    public void initServiceEndpoints() {
        OSClientSessionAKSK osclient = (OSClientSessionAKSK)OSClientSession.getCurrent();
        List<Object> services = new ArrayList();
        List<Object> endpoints = new ArrayList();
        try {
            services = osclient.identity().serviceEndpoints().list();
            endpoints = osclient.identity().serviceEndpoints().listEndpoints();
        }
        catch (Exception e) {
            LOG.error("IAM Endpint failed to get, the specific reason is:" + e);
            return;
        }
        HashMap<ServiceType, ServiceEndpointProvider.ServiceEndpoint> serviceEndpoints = new HashMap<ServiceType, ServiceEndpointProvider.ServiceEndpoint>();
        block2: for (Service service : services) {
            for (Endpoint endpoint : endpoints) {
                ServiceType serviceType;
                if (service.getId() == null || !service.getId().equals(endpoint.getServiceId())) continue;
                if (this.region == null) continue block2;
                if (!this.region.equalsIgnoreCase(endpoint.getRegion()) || !"PUBLIC".equalsIgnoreCase(endpoint.getIface().toString()) || (serviceType = ServiceType.forName(service.getType())) == ServiceType.UNKNOWN) continue;
                ServiceEndpointProvider.ServiceEndpoint serviceEndpoint = new ServiceEndpointProvider.ServiceEndpoint();
                serviceEndpoint.setPublicEndpoint(endpoint.getUrl().toString());
                serviceEndpoints.put(serviceType, serviceEndpoint);
            }
        }
        this.serviceEndpoints = serviceEndpoints;
        sessions.set(this);
    }

    private String addNATIfApplicable(String url) {
        if (this.config != null && this.config.isBehindNAT()) {
            try {
                URI uri = new URI(url);
                return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
            }
            catch (URISyntaxException e) {
                LoggerFactory.getLogger(OSClientSessionAKSK.class).error(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    @Override
    public String getTokenId() {
        return null;
    }

    @Override
    public AuthVersion getAuthVersion() {
        return AuthVersion.AKSK;
    }

    @Override
    public boolean supportsReAuthentication() {
        return false;
    }

    @Override
    public OSClient.OSClientAKSK credentials(String accessKey, String secretKey, String region, String projectId, String cloudDomainName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"parameter `projectId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `cloudDomainName` should not be empty");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.cloudDomainName = cloudDomainName;
        this.projectId = projectId;
        this.useRegion(region);
        sessions.set(this);
        this.initServiceEndpoints();
        return this;
    }

    @Override
    public OSClient.OSClientAKSK credentials(String accessKey, String secretKey, String region, String projectId, String domainId, String cloudDomainName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domainId) ? 1 : 0) != 0, (Object)"parameter `domainId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `domain` should not be empty");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.cloudDomainName = cloudDomainName;
        this.domainId = domainId;
        this.projectId = projectId;
        this.useRegion(region);
        sessions.set(this);
        this.initServiceEndpoints();
        return this;
    }

    @Override
    public OSClient.OSClientAKSK credentials(String accessKey, String secretKey, String region, String cloudDomainName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `domain` should not be empty");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.cloudDomainName = cloudDomainName;
        this.useRegion(region);
        sessions.set(this);
        this.initServiceEndpoints();
        return this;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getCloudDomain() {
        return this.cloudDomainName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public IdentityService identity() {
        return Apis.getIdentityV3Services();
    }
}

