/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.api.client.CloudProvider;
import com.huawei.openstack4j.api.exceptions.RegionEndpointNotFoundException;
import com.huawei.openstack4j.api.identity.EndpointURLResolver;
import com.huawei.openstack4j.api.identity.v3.IdentityService;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.model.identity.AuthVersion;
import com.huawei.openstack4j.model.identity.URLResolverParams;
import com.huawei.openstack4j.openstack.identity.internal.AKSKEndpointURLResolver;
import com.huawei.openstack4j.openstack.internal.OSClientSession;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.LoggerFactory;

public class OSClientSessionTempAKSK
extends OSClientSession<OSClientSessionTempAKSK, OSClient.OSClientTempAKSK>
implements OSClient.OSClientTempAKSK {
    private String accessKey;
    private String secretKey;
    private String cloudDomainName;
    private String projectId;
    private String domainId;
    private String securityToken;
    CloudProvider provider = CloudProvider.HUAWEI;
    protected EndpointURLResolver defaultEndpointURLResolver = AKSKEndpointURLResolver.instance();

    @Override
    public String getEndpoint() {
        throw new RuntimeException("Token is not required by AKSK-authentication");
    }

    @Override
    public String getEndpoint(ServiceType service) {
        URLResolverParams params = URLResolverParams.create(service).perspective(this.perspective).region(this.region).domain(this.cloudDomainName).projectId(this.projectId);
        String url = null;
        try {
            if (this.config != null && this.config.getEndpointURLResolver() != null) {
                url = this.config.getEndpointURLResolver().resolve(params);
                if (url == null) {
                    url = this.defaultEndpointURLResolver.resolve(params);
                }
            } else {
                url = this.defaultEndpointURLResolver.resolve(params);
            }
        }
        catch (NullPointerException e) {
            throw new RegionEndpointNotFoundException("region endpoint can not be found");
        }
        return this.addNATIfApplicable(url);
    }

    private String addNATIfApplicable(String url) {
        if (this.config != null && this.config.isBehindNAT()) {
            try {
                URI uri = new URI(url);
                return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
            }
            catch (URISyntaxException e) {
                LoggerFactory.getLogger(OSClientSessionTempAKSK.class).error(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    @Override
    public String getTokenId() {
        return null;
    }

    @Override
    public AuthVersion getAuthVersion() {
        return AuthVersion.AKSK;
    }

    @Override
    public boolean supportsReAuthentication() {
        return false;
    }

    @Override
    public OSClient.OSClientTempAKSK credentials(String accessKey, String secretKey, String region, String projectId, String cloudDomainName, String securityToken) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"parameter `projectId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `cloudDomainName` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityToken) ? 1 : 0) != 0, (Object)"parameter `securityToken` should not be empty");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.cloudDomainName = cloudDomainName;
        this.projectId = projectId;
        this.securityToken = securityToken;
        this.useRegion(region);
        sessions.set(this);
        return this;
    }

    @Override
    public OSClient.OSClientTempAKSK credentials(String accessKey, String secretKey, String region, String projectId, String domainId, String cloudDomainName, String securityToken) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domainId) ? 1 : 0) != 0, (Object)"parameter `domainId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `domain` should not be empty");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.cloudDomainName = cloudDomainName;
        this.domainId = domainId;
        this.projectId = projectId;
        this.securityToken = securityToken;
        this.useRegion(region);
        sessions.set(this);
        return this;
    }

    @Override
    public OSClient.OSClientTempAKSK credentials(String accessKey, String secretKey, String region, String cloudDomainName, String securityToken) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `domain` should not be empty");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.cloudDomainName = cloudDomainName;
        this.securityToken = securityToken;
        this.useRegion(region);
        sessions.set(this);
        return this;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getCloudDomain() {
        return this.cloudDomainName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getRegion() {
        return this.region;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    @Override
    public IdentityService identity() {
        return Apis.getIdentityV3Services();
    }
}

