/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.kms.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.common.serializer.BooleanDeserializer;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.kms.constants.KeyState;
import com.huawei.openstack4j.openstack.kms.constants.PartitionType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

public class Key
implements ModelEntity {
    private static final long serialVersionUID = -6764087311133427927L;
    @JsonProperty(value="key_id")
    String id;
    @JsonProperty(value="key_type")
    String type;
    @JsonProperty(value="domain_id")
    String domainId;
    @JsonProperty(value="key_alias")
    String alias;
    @JsonProperty(value="realm")
    String realm;
    @JsonProperty(value="key_description")
    String description;
    @JsonProperty(value="creation_date")
    Date creationDate;
    @JsonProperty(value="scheduled_deletion_date")
    Date scheduledDeletionDate;
    @JsonProperty(value="key_state")
    KeyState state;
    @JsonProperty(value="partition_id")
    String partitionId;
    @JsonProperty(value="partition_type")
    PartitionType partitionType;
    @JsonProperty(value="default_key_flag")
    @JsonDeserialize(using=BooleanDeserializer.class)
    Boolean isDefaultKey;

    public static KeyBuilder builder() {
        return new KeyBuilder();
    }

    public KeyBuilder toBuilder() {
        return new KeyBuilder().id(this.id).type(this.type).domainId(this.domainId).alias(this.alias).realm(this.realm).description(this.description).creationDate(this.creationDate).scheduledDeletionDate(this.scheduledDeletionDate).state(this.state).partitionId(this.partitionId).partitionType(this.partitionType).isDefaultKey(this.isDefaultKey);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getScheduledDeletionDate() {
        return this.scheduledDeletionDate;
    }

    public KeyState getState() {
        return this.state;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    public Boolean getIsDefaultKey() {
        return this.isDefaultKey;
    }

    public String toString() {
        return "Key(id=" + this.getId() + ", type=" + this.getType() + ", domainId=" + this.getDomainId() + ", alias=" + this.getAlias() + ", realm=" + this.getRealm() + ", description=" + this.getDescription() + ", creationDate=" + this.getCreationDate() + ", scheduledDeletionDate=" + this.getScheduledDeletionDate() + ", state=" + (Object)((Object)this.getState()) + ", partitionId=" + this.getPartitionId() + ", partitionType=" + (Object)((Object)this.getPartitionType()) + ", isDefaultKey=" + this.getIsDefaultKey() + ")";
    }

    public Key() {
    }

    @ConstructorProperties(value={"id", "type", "domainId", "alias", "realm", "description", "creationDate", "scheduledDeletionDate", "state", "partitionId", "partitionType", "isDefaultKey"})
    public Key(String id, String type, String domainId, String alias, String realm, String description, Date creationDate, Date scheduledDeletionDate, KeyState state, String partitionId, PartitionType partitionType, Boolean isDefaultKey) {
        this.id = id;
        this.type = type;
        this.domainId = domainId;
        this.alias = alias;
        this.realm = realm;
        this.description = description;
        this.creationDate = creationDate;
        this.scheduledDeletionDate = scheduledDeletionDate;
        this.state = state;
        this.partitionId = partitionId;
        this.partitionType = partitionType;
        this.isDefaultKey = isDefaultKey;
    }

    public static class KeyBuilder {
        private String id;
        private String type;
        private String domainId;
        private String alias;
        private String realm;
        private String description;
        private Date creationDate;
        private Date scheduledDeletionDate;
        private KeyState state;
        private String partitionId;
        private PartitionType partitionType;
        private Boolean isDefaultKey;

        KeyBuilder() {
        }

        public KeyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public KeyBuilder type(String type) {
            this.type = type;
            return this;
        }

        public KeyBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public KeyBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public KeyBuilder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public KeyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KeyBuilder creationDate(Date creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public KeyBuilder scheduledDeletionDate(Date scheduledDeletionDate) {
            this.scheduledDeletionDate = scheduledDeletionDate;
            return this;
        }

        public KeyBuilder state(KeyState state) {
            this.state = state;
            return this;
        }

        public KeyBuilder partitionId(String partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public KeyBuilder partitionType(PartitionType partitionType) {
            this.partitionType = partitionType;
            return this;
        }

        public KeyBuilder isDefaultKey(Boolean isDefaultKey) {
            this.isDefaultKey = isDefaultKey;
            return this;
        }

        public Key build() {
            return new Key(this.id, this.type, this.domainId, this.alias, this.realm, this.description, this.creationDate, this.scheduledDeletionDate, this.state, this.partitionId, this.partitionType, this.isDefaultKey);
        }

        public String toString() {
            return "Key.KeyBuilder(id=" + this.id + ", type=" + this.type + ", domainId=" + this.domainId + ", alias=" + this.alias + ", realm=" + this.realm + ", description=" + this.description + ", creationDate=" + this.creationDate + ", scheduledDeletionDate=" + this.scheduledDeletionDate + ", state=" + (Object)((Object)this.state) + ", partitionId=" + this.partitionId + ", partitionType=" + (Object)((Object)this.partitionType) + ", isDefaultKey=" + this.isDefaultKey + ")";
        }
    }

    public static class Keys
    extends ListResult<Key> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="keys")
        private List<String> keys;
        @JsonProperty(value="key_details")
        private List<Key> keyDetails;
        @JsonProperty(value="next_marker")
        String nextMarker;
        @JsonProperty(value="truncated")
        Boolean truncated;

        @Override
        public List<Key> value() {
            return this.keyDetails;
        }

        public List<String> get() {
            return this.keys;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public Boolean getTruncated() {
            return this.truncated;
        }
    }
}

