/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.kms.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.openstack.common.Quota;
import com.huawei.openstack4j.openstack.kms.domain.Key;
import com.huawei.openstack4j.openstack.kms.domain.KeyCreate;
import com.huawei.openstack4j.openstack.kms.domain.KeyWrap;
import com.huawei.openstack4j.openstack.kms.internal.BaseKeyManagementService;
import com.huawei.openstack4j.openstack.kms.options.KeyListOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyService
extends BaseKeyManagementService
implements RestService {
    public Key.Keys list(KeyListOptions options) {
        Map<String, Object> params = options == null ? null : options.getOptions();
        return this.post(Key.Keys.class, "/kms/list-keys").entity(params).execute();
    }

    public Key get(String keyId, String sequence) {
        Preconditions.checkNotNull((Object)keyId);
        KeyActionRequest request = new KeyActionRequest(keyId, sequence);
        KeyWrap execute = this.post(KeyWrap.class, "/kms/describe-key").entity(request).execute();
        return execute.getKey();
    }

    public Key create(KeyCreate keyCreate) {
        Preconditions.checkNotNull((Object)keyCreate);
        KeyWrap execute = this.post(KeyWrap.class, this.uri("/kms/create-key", new Object[0])).entity(keyCreate).execute();
        return execute.getKey();
    }

    public Key enable(String keyId, String sequence) {
        Preconditions.checkNotNull((Object)keyId);
        KeyActionRequest request = new KeyActionRequest(keyId, sequence);
        KeyWrap execute = this.post(KeyWrap.class, "/kms/enable-key").entity(request).execute();
        return execute.getKey();
    }

    public Key disable(String keyId, String sequence) {
        Preconditions.checkNotNull((Object)keyId);
        KeyActionRequest request = new KeyActionRequest(keyId, sequence);
        KeyWrap execute = this.post(KeyWrap.class, "/kms/disable-key").entity(request).execute();
        return execute.getKey();
    }

    public Key scheduleDeletion(String keyId, Integer pendingDays, String sequence) {
        Preconditions.checkNotNull((Object)keyId);
        Preconditions.checkNotNull((Object)pendingDays);
        KeyActionRequest request = new KeyActionRequest(keyId, pendingDays, sequence);
        return this.post(Key.class, "/kms/schedule-key-deletion").entity(request).execute();
    }

    public Key cancelDeletion(String keyId, String sequence) {
        Preconditions.checkNotNull((Object)keyId);
        KeyActionRequest request = new KeyActionRequest(keyId, sequence);
        return this.post(Key.class, "/kms/cancel-key-deletion").entity(request).execute();
    }

    public Integer getKeyCreatedAmount() {
        HashMap execute = this.get(HashMap.class, "/kms/user-instances").execute();
        return (Integer)execute.get("instance_num");
    }

    public List<Quota> quotas() {
        Quota.Quotas quotas = this.get(Quota.Quotas.class, "/kms/user-quotas").execute();
        return quotas.getList();
    }

    static class KeyActionRequest {
        @JsonProperty(value="key_id")
        String id;
        @JsonProperty(value="sequence")
        String sequence;
        @JsonProperty(value="pending_days")
        Integer pendingDays;

        public KeyActionRequest(String id, Integer pendingDays, String sequence) {
            this.id = id;
            this.pendingDays = pendingDays;
            this.sequence = sequence;
        }

        public KeyActionRequest(String id, String sequence) {
            this.id = id;
            this.sequence = sequence;
        }

        public String getId() {
            return this.id;
        }

        public String getSequence() {
            return this.sequence;
        }
    }
}

