/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;
import java.util.Map;

public class AsyncJob
implements ModelEntity {
    private static final long serialVersionUID = -4122799701625680047L;
    @JsonProperty
    private Status status;
    @JsonProperty
    private Map<String, Object> entities;
    @JsonProperty(value="job_id")
    private String jobId;
    @JsonProperty(value="job_type")
    private String jobType;
    @JsonProperty(value="error_code")
    private String errorCode;
    @JsonProperty(value="fail_reason")
    private String failReason;

    public Map<String, Object> getEntities() {
        return this.entities;
    }

    public static AsyncJobBuilder builder() {
        return new AsyncJobBuilder();
    }

    public AsyncJobBuilder toBuilder() {
        return new AsyncJobBuilder().status(this.status).entities(this.entities).jobId(this.jobId).jobType(this.jobType).errorCode(this.errorCode).failReason(this.failReason);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public String toString() {
        return "AsyncJob(status=" + (Object)((Object)this.getStatus()) + ", entities=" + this.getEntities() + ", jobId=" + this.getJobId() + ", jobType=" + this.getJobType() + ", errorCode=" + this.getErrorCode() + ", failReason=" + this.getFailReason() + ")";
    }

    public AsyncJob() {
    }

    @ConstructorProperties(value={"status", "entities", "jobId", "jobType", "errorCode", "failReason"})
    public AsyncJob(Status status, Map<String, Object> entities, String jobId, String jobType, String errorCode, String failReason) {
        this.status = status;
        this.entities = entities;
        this.jobId = jobId;
        this.jobType = jobType;
        this.errorCode = errorCode;
        this.failReason = failReason;
    }

    public static class AsyncJobBuilder {
        private Status status;
        private Map<String, Object> entities;
        private String jobId;
        private String jobType;
        private String errorCode;
        private String failReason;

        AsyncJobBuilder() {
        }

        public AsyncJobBuilder status(Status status) {
            this.status = status;
            return this;
        }

        public AsyncJobBuilder entities(Map<String, Object> entities) {
            this.entities = entities;
            return this;
        }

        public AsyncJobBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public AsyncJobBuilder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        public AsyncJobBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public AsyncJobBuilder failReason(String failReason) {
            this.failReason = failReason;
            return this;
        }

        public AsyncJob build() {
            return new AsyncJob(this.status, this.entities, this.jobId, this.jobType, this.errorCode, this.failReason);
        }

        public String toString() {
            return "AsyncJob.AsyncJobBuilder(status=" + (Object)((Object)this.status) + ", entities=" + this.entities + ", jobId=" + this.jobId + ", jobType=" + this.jobType + ", errorCode=" + this.errorCode + ", failReason=" + this.failReason + ")";
        }
    }

    public static enum Status {
        SUCCESS,
        FAIL,
        RUNNING,
        INIT;

    }
}

