/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.domain;

import com.huawei.openstack4j.model.loadbalance.Certificate;
import com.huawei.openstack4j.model.loadbalance.CertificateUpdate;
import java.beans.ConstructorProperties;

public class ELBCertificateUpdate
implements CertificateUpdate {
    private static final long serialVersionUID = -4953327488993502029L;
    private String name;
    private String description;

    public static ELBCertificateUpdate fromCertificate(Certificate cert) {
        return ELBCertificateUpdate.builder().name(cert.getName()).description(cert.getDescription()).build();
    }

    public static ELBCertificateUpdateBuilder builder() {
        return new ELBCertificateUpdateBuilder();
    }

    public ELBCertificateUpdateBuilder toBuilder() {
        return new ELBCertificateUpdateBuilder().name(this.name).description(this.description);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ELBCertificateUpdate(name=" + this.getName() + ", description=" + this.getDescription() + ")";
    }

    public ELBCertificateUpdate() {
    }

    @ConstructorProperties(value={"name", "description"})
    public ELBCertificateUpdate(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static class ELBCertificateUpdateBuilder {
        private String name;
        private String description;

        ELBCertificateUpdateBuilder() {
        }

        public ELBCertificateUpdateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ELBCertificateUpdateBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ELBCertificateUpdate build() {
            return new ELBCertificateUpdate(this.name, this.description);
        }

        public String toString() {
            return "ELBCertificateUpdate.ELBCertificateUpdateBuilder(name=" + this.name + ", description=" + this.description + ")";
        }
    }
}

