/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.loadbalance.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.loadbalance.LoadBalancer;
import com.huawei.openstack4j.model.loadbalance.LoadBalancerUpdate;
import java.beans.ConstructorProperties;

public class ELBLoadBalancerUpdate
implements LoadBalancerUpdate {
    private static final long serialVersionUID = 742286551840027186L;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private Integer bandwidth;
    @JsonProperty(value="admin_state_up")
    private Integer adminStateUp;
    @JsonProperty
    private String tenantId;

    public static ELBLoadBalancerUpdate fromLoadBalancer(LoadBalancer loadBalancer) {
        return ELBLoadBalancerUpdate.builder().name(loadBalancer.getName()).description(loadBalancer.getDescription()).bandwidth(loadBalancer.getBandwidth()).adminStateUp(loadBalancer.getAdminStateUp()).build();
    }

    public static ELBLoadBalancerUpdateBuilder builder() {
        return new ELBLoadBalancerUpdateBuilder();
    }

    public ELBLoadBalancerUpdateBuilder toBuilder() {
        return new ELBLoadBalancerUpdateBuilder().name(this.name).description(this.description).bandwidth(this.bandwidth).adminStateUp(this.adminStateUp).tenantId(this.tenantId);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Integer getBandwidth() {
        return this.bandwidth;
    }

    @Override
    public Integer getAdminStateUp() {
        return this.adminStateUp;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return "ELBLoadBalancerUpdate(name=" + this.getName() + ", description=" + this.getDescription() + ", bandwidth=" + this.getBandwidth() + ", adminStateUp=" + this.getAdminStateUp() + ", tenantId=" + this.getTenantId() + ")";
    }

    public ELBLoadBalancerUpdate() {
    }

    @ConstructorProperties(value={"name", "description", "bandwidth", "adminStateUp", "tenantId"})
    public ELBLoadBalancerUpdate(String name, String description, Integer bandwidth, Integer adminStateUp, String tenantId) {
        this.name = name;
        this.description = description;
        this.bandwidth = bandwidth;
        this.adminStateUp = adminStateUp;
        this.tenantId = tenantId;
    }

    public static class ELBLoadBalancerUpdateBuilder {
        private String name;
        private String description;
        private Integer bandwidth;
        private Integer adminStateUp;
        private String tenantId;

        ELBLoadBalancerUpdateBuilder() {
        }

        public ELBLoadBalancerUpdateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ELBLoadBalancerUpdateBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ELBLoadBalancerUpdateBuilder bandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public ELBLoadBalancerUpdateBuilder adminStateUp(Integer adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this;
        }

        public ELBLoadBalancerUpdateBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public ELBLoadBalancerUpdate build() {
            return new ELBLoadBalancerUpdate(this.name, this.description, this.bandwidth, this.adminStateUp, this.tenantId);
        }

        public String toString() {
            return "ELBLoadBalancerUpdate.ELBLoadBalancerUpdateBuilder(name=" + this.name + ", description=" + this.description + ", bandwidth=" + this.bandwidth + ", adminStateUp=" + this.adminStateUp + ", tenantId=" + this.tenantId + ")";
        }
    }
}

