/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.maas.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.maas.constants.TriggerCondition;
import java.beans.ConstructorProperties;
import java.util.List;

public class TaskCreate
implements ModelEntity {
    private static final long serialVersionUID = 836240938288167164L;
    @JsonProperty(value="src_node")
    private Node srcNode;
    @JsonProperty(value="dst_node")
    private Node dstNode;
    private Boolean enableKMS;
    @JsonProperty(value="thread_num")
    private Integer threadNum;
    private String description;
    private SmnInfo smnInfo;

    public static TaskCreateBuilder builder() {
        return new TaskCreateBuilder();
    }

    public TaskCreateBuilder toBuilder() {
        return new TaskCreateBuilder().srcNode(this.srcNode).dstNode(this.dstNode).enableKMS(this.enableKMS).threadNum(this.threadNum).description(this.description).smnInfo(this.smnInfo);
    }

    public Node getSrcNode() {
        return this.srcNode;
    }

    public Node getDstNode() {
        return this.dstNode;
    }

    public Boolean getEnableKMS() {
        return this.enableKMS;
    }

    public Integer getThreadNum() {
        return this.threadNum;
    }

    public String getDescription() {
        return this.description;
    }

    public SmnInfo getSmnInfo() {
        return this.smnInfo;
    }

    public String toString() {
        return "TaskCreate(srcNode=" + this.getSrcNode() + ", dstNode=" + this.getDstNode() + ", enableKMS=" + this.getEnableKMS() + ", threadNum=" + this.getThreadNum() + ", description=" + this.getDescription() + ", smnInfo=" + this.getSmnInfo() + ")";
    }

    public TaskCreate() {
    }

    @ConstructorProperties(value={"srcNode", "dstNode", "enableKMS", "threadNum", "description", "smnInfo"})
    public TaskCreate(Node srcNode, Node dstNode, Boolean enableKMS, Integer threadNum, String description, SmnInfo smnInfo) {
        this.srcNode = srcNode;
        this.dstNode = dstNode;
        this.enableKMS = enableKMS;
        this.threadNum = threadNum;
        this.description = description;
        this.smnInfo = smnInfo;
    }

    public static class TaskCreateBuilder {
        private Node srcNode;
        private Node dstNode;
        private Boolean enableKMS;
        private Integer threadNum;
        private String description;
        private SmnInfo smnInfo;

        TaskCreateBuilder() {
        }

        public TaskCreateBuilder srcNode(Node srcNode) {
            this.srcNode = srcNode;
            return this;
        }

        public TaskCreateBuilder dstNode(Node dstNode) {
            this.dstNode = dstNode;
            return this;
        }

        public TaskCreateBuilder enableKMS(Boolean enableKMS) {
            this.enableKMS = enableKMS;
            return this;
        }

        public TaskCreateBuilder threadNum(Integer threadNum) {
            this.threadNum = threadNum;
            return this;
        }

        public TaskCreateBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TaskCreateBuilder smnInfo(SmnInfo smnInfo) {
            this.smnInfo = smnInfo;
            return this;
        }

        public TaskCreate build() {
            return new TaskCreate(this.srcNode, this.dstNode, this.enableKMS, this.threadNum, this.description, this.smnInfo);
        }

        public String toString() {
            return "TaskCreate.TaskCreateBuilder(srcNode=" + this.srcNode + ", dstNode=" + this.dstNode + ", enableKMS=" + this.enableKMS + ", threadNum=" + this.threadNum + ", description=" + this.description + ", smnInfo=" + this.smnInfo + ")";
        }
    }

    public static class SmnInfo {
        private String topicUrn;
        private String language;
        private List<TriggerCondition> triggerConditions;

        public static SmnInfoBuilder builder() {
            return new SmnInfoBuilder();
        }

        public SmnInfoBuilder toBuilder() {
            return new SmnInfoBuilder().topicUrn(this.topicUrn).language(this.language).triggerConditions(this.triggerConditions);
        }

        public String getTopicUrn() {
            return this.topicUrn;
        }

        public String getLanguage() {
            return this.language;
        }

        public List<TriggerCondition> getTriggerConditions() {
            return this.triggerConditions;
        }

        public String toString() {
            return "TaskCreate.SmnInfo(topicUrn=" + this.getTopicUrn() + ", language=" + this.getLanguage() + ", triggerConditions=" + this.getTriggerConditions() + ")";
        }

        public SmnInfo() {
        }

        @ConstructorProperties(value={"topicUrn", "language", "triggerConditions"})
        public SmnInfo(String topicUrn, String language, List<TriggerCondition> triggerConditions) {
            this.topicUrn = topicUrn;
            this.language = language;
            this.triggerConditions = triggerConditions;
        }

        public static class SmnInfoBuilder {
            private String topicUrn;
            private String language;
            private List<TriggerCondition> triggerConditions;

            SmnInfoBuilder() {
            }

            public SmnInfoBuilder topicUrn(String topicUrn) {
                this.topicUrn = topicUrn;
                return this;
            }

            public SmnInfoBuilder language(String language) {
                this.language = language;
                return this;
            }

            public SmnInfoBuilder triggerConditions(List<TriggerCondition> triggerConditions) {
                this.triggerConditions = triggerConditions;
                return this;
            }

            public SmnInfo build() {
                return new SmnInfo(this.topicUrn, this.language, this.triggerConditions);
            }

            public String toString() {
                return "TaskCreate.SmnInfo.SmnInfoBuilder(topicUrn=" + this.topicUrn + ", language=" + this.language + ", triggerConditions=" + this.triggerConditions + ")";
            }
        }
    }

    public static class Node {
        private String region;
        private String ak;
        private String sk;
        @JsonProperty(value="object_key")
        private Object objectKey;
        private String bucket;

        public static NodeBuilder builder() {
            return new NodeBuilder();
        }

        public NodeBuilder toBuilder() {
            return new NodeBuilder().region(this.region).ak(this.ak).sk(this.sk).objectKey(this.objectKey).bucket(this.bucket);
        }

        public String getRegion() {
            return this.region;
        }

        public String getAk() {
            return this.ak;
        }

        public String getSk() {
            return this.sk;
        }

        public Object getObjectKey() {
            return this.objectKey;
        }

        public String getBucket() {
            return this.bucket;
        }

        public String toString() {
            return "TaskCreate.Node(region=" + this.getRegion() + ", ak=" + this.getAk() + ", sk=" + this.getSk() + ", objectKey=" + this.getObjectKey() + ", bucket=" + this.getBucket() + ")";
        }

        public Node() {
        }

        @ConstructorProperties(value={"region", "ak", "sk", "objectKey", "bucket"})
        public Node(String region, String ak, String sk, Object objectKey, String bucket) {
            this.region = region;
            this.ak = ak;
            this.sk = sk;
            this.objectKey = objectKey;
            this.bucket = bucket;
        }

        public static class NodeBuilder {
            private String region;
            private String ak;
            private String sk;
            private Object objectKey;
            private String bucket;

            NodeBuilder() {
            }

            public NodeBuilder region(String region) {
                this.region = region;
                return this;
            }

            public NodeBuilder ak(String ak) {
                this.ak = ak;
                return this;
            }

            public NodeBuilder sk(String sk) {
                this.sk = sk;
                return this;
            }

            public NodeBuilder objectKey(Object objectKey) {
                this.objectKey = objectKey;
                return this;
            }

            public NodeBuilder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Node build() {
                return new Node(this.region, this.ak, this.sk, this.objectKey, this.bucket);
            }

            public String toString() {
                return "TaskCreate.Node.NodeBuilder(region=" + this.region + ", ak=" + this.ak + ", sk=" + this.sk + ", objectKey=" + this.objectKey + ", bucket=" + this.bucket + ")";
            }
        }
    }
}

