/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.manila.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.manila.ShareTypeService;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.manila.ExtraSpecs;
import com.huawei.openstack4j.model.manila.ShareType;
import com.huawei.openstack4j.model.manila.ShareTypeAccess;
import com.huawei.openstack4j.model.manila.ShareTypeCreate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.manila.domain.ManilaShareType;
import com.huawei.openstack4j.openstack.manila.domain.actions.ShareTypeAction;
import com.huawei.openstack4j.openstack.manila.domain.actions.ShareTypeActions;
import com.huawei.openstack4j.openstack.manila.internal.BaseShareServices;
import java.util.List;

public class ShareTypeServiceImpl
extends BaseShareServices
implements ShareTypeService {
    @Override
    public ShareType create(ShareTypeCreate shareTypeCreate) {
        Preconditions.checkNotNull((Object)shareTypeCreate);
        return this.post(ShareVolumeTypeWrapper.class, this.uri("/types", new Object[0])).entity(shareTypeCreate).execute().shareType;
    }

    @Override
    public List<? extends ShareType> list() {
        return this.get(ManilaShareType.ShareTypes.class, this.uri("/types", new Object[0])).execute().getList();
    }

    @Override
    public ShareType listDefaults() {
        return this.get(ShareVolumeTypeWrapper.class, this.uri("/types/default", new Object[0])).execute().shareType;
    }

    @Override
    public ActionResponse delete(String shareTypeId) {
        Preconditions.checkNotNull((Object)shareTypeId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/types/%s", shareTypeId)).executeWithResponse());
    }

    @Override
    public ExtraSpecs listExtraSpecs(String shareTypeId) {
        Preconditions.checkNotNull((Object)shareTypeId);
        return this.get(ExtraSpecs.class, this.uri("/types/%s/extra_specs", shareTypeId)).execute();
    }

    @Override
    public ExtraSpecs setExtraSpec(String shareTypeId, ExtraSpecs extraSpecs) {
        Preconditions.checkNotNull((Object)shareTypeId);
        Preconditions.checkNotNull((Object)extraSpecs);
        return this.post(ExtraSpecs.class, this.uri("/types/%s/extra_specs", shareTypeId)).entity(extraSpecs).execute();
    }

    @Override
    public ActionResponse unsetExtraSpec(String shareTypeId, String extraSpecKey) {
        Preconditions.checkNotNull((Object)shareTypeId);
        Preconditions.checkNotNull((Object)extraSpecKey);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/types/%s/extra_specs/%s", shareTypeId, extraSpecKey)).executeWithResponse());
    }

    @Override
    public ActionResponse addShareTypeAccess(String shareTypeId, String projectId) {
        Preconditions.checkNotNull((Object)shareTypeId);
        Preconditions.checkNotNull((Object)projectId);
        return this.invokeAction(shareTypeId, ShareTypeActions.addShareTypeAccess(projectId));
    }

    @Override
    public ActionResponse removeShareTypeAccess(String shareTypeId, String projectId) {
        Preconditions.checkNotNull((Object)shareTypeId);
        Preconditions.checkNotNull((Object)projectId);
        return this.invokeAction(shareTypeId, ShareTypeActions.removeShareTypeAccess(projectId));
    }

    private ActionResponse invokeAction(String shareTypeId, ShareTypeAction action) {
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/types/%s/action", shareTypeId)).entity(action).executeWithResponse());
    }

    @Override
    public List<? extends ShareTypeAccess> shareTypeAccessDetails(String shareTypeId) {
        Preconditions.checkNotNull((Object)shareTypeId);
        return this.get(ShareTypeAccess.ShareTypeAccessList.class, this.uri("/types/%s/os-share-type-access", shareTypeId)).execute().getList();
    }

    private static class ShareVolumeTypeWrapper
    implements ModelEntity {
        @JsonProperty(value="volume_type")
        private ManilaShareType volumeType;
        @JsonProperty(value="share_type")
        private ManilaShareType shareType;

        private ShareVolumeTypeWrapper() {
        }
    }
}

