/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.map.reduce.domain.ClusterScalingParams;
import java.beans.ConstructorProperties;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClusterScalingReq
implements ModelEntity {
    private static final long serialVersionUID = 8385091343927428645L;
    @JsonProperty(value="service_id")
    private String serviceId;
    @JsonProperty(value="plan_id")
    private String planId;
    @JsonProperty(value="parameters")
    private ClusterScalingParams parameters;
    @JsonProperty(value="previous_values")
    private Map<String, String> previousValue;

    @ConstructorProperties(value={"serviceId", "planId", "parameters", "previousValue"})
    ClusterScalingReq(String serviceId, String planId, ClusterScalingParams parameters, Map<String, String> previousValue) {
        this.serviceId = serviceId;
        this.planId = planId;
        this.parameters = parameters;
        this.previousValue = previousValue;
    }

    public static ClusterScalingReqBuilder builder() {
        return new ClusterScalingReqBuilder();
    }

    public ClusterScalingReqBuilder toBuilder() {
        return new ClusterScalingReqBuilder().serviceId(this.serviceId).planId(this.planId).parameters(this.parameters).previousValue(this.previousValue);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getPlanId() {
        return this.planId;
    }

    public ClusterScalingParams getParameters() {
        return this.parameters;
    }

    public Map<String, String> getPreviousValue() {
        return this.previousValue;
    }

    public String toString() {
        return "ClusterScalingReq(serviceId=" + this.getServiceId() + ", planId=" + this.getPlanId() + ", parameters=" + this.getParameters() + ", previousValue=" + this.getPreviousValue() + ")";
    }

    public static class ClusterScalingReqBuilder {
        private String serviceId;
        private String planId;
        private ClusterScalingParams parameters;
        private Map<String, String> previousValue;

        ClusterScalingReqBuilder() {
        }

        public ClusterScalingReqBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public ClusterScalingReqBuilder planId(String planId) {
            this.planId = planId;
            return this;
        }

        public ClusterScalingReqBuilder parameters(ClusterScalingParams parameters) {
            this.parameters = parameters;
            return this;
        }

        public ClusterScalingReqBuilder previousValue(Map<String, String> previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public ClusterScalingReq build() {
            return new ClusterScalingReq(this.serviceId, this.planId, this.parameters, this.previousValue);
        }

        public String toString() {
            return "ClusterScalingReq.ClusterScalingReqBuilder(serviceId=" + this.serviceId + ", planId=" + this.planId + ", parameters=" + this.parameters + ", previousValue=" + this.previousValue + ")";
        }
    }
}

