/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.map.reduce.ClusterTemplate;
import com.huawei.openstack4j.model.map.reduce.NodeGroup;
import com.huawei.openstack4j.model.map.reduce.ServiceConfig;
import com.huawei.openstack4j.model.map.reduce.builder.ClusterTemplateBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceNodeGroup;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceServiceConfig;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonRootName(value="cluster_template")
public class MapReduceClusterTemplate
implements ClusterTemplate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="hadoop_version")
    private String hadoopVersion;
    @JsonProperty(value="default_image_id")
    private String defaultImageId;
    private String name;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="plugin_name")
    private String pluginName;
    @JsonProperty(value="anti_affinity")
    private List<String> antiAffinity;
    private String description;
    private String id;
    @JsonProperty(value="node_groups")
    private List<MapReduceNodeGroup> nodeGroups;
    @JsonProperty(value="neutron_management_network")
    private String managementNetworkId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="cluster_configs")
    private Map<String, MapReduceServiceConfig> clusterConfigs;

    @Override
    public ClusterTemplateBuilder toBuilder() {
        return new ConcreteClusterTemplateBuilder(this);
    }

    public static ClusterTemplateBuilder builder() {
        return new ConcreteClusterTemplateBuilder();
    }

    @Override
    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    @Override
    public String getDefaultImageId() {
        return this.defaultImageId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public List<String> getAntiAffinity() {
        return this.antiAffinity;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<? extends NodeGroup> getNodeGroups() {
        return this.nodeGroups;
    }

    @Override
    public String getManagementNetworkId() {
        return this.managementNetworkId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Map<String, ? extends ServiceConfig> getClusterConfigs() {
        return this.clusterConfigs;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("hadoop_version", (Object)this.hadoopVersion).add("tenant_id", (Object)this.tenantId).add("created_at", (Object)this.createdAt).add("updated_at", (Object)this.updatedAt).add("plugin_name", (Object)this.pluginName).add("default_image_id", (Object)this.defaultImageId).add("anti_affinity", this.antiAffinity).add("neutron_management_network_id", (Object)this.managementNetworkId).add("node_groups", this.nodeGroups).add("cluster_configs", this.clusterConfigs).toString();
    }

    public static class ConcreteClusterTemplateBuilder
    implements ClusterTemplateBuilder {
        private MapReduceClusterTemplate m;

        ConcreteClusterTemplateBuilder() {
            this(new MapReduceClusterTemplate());
        }

        ConcreteClusterTemplateBuilder(MapReduceClusterTemplate m) {
            this.m = m;
        }

        @Override
        public ClusterTemplate build() {
            return this.m;
        }

        @Override
        public ClusterTemplateBuilder from(ClusterTemplate in) {
            this.m = (MapReduceClusterTemplate)in;
            return this;
        }

        @Override
        public ClusterTemplateBuilder pluginName(String pluginName) {
            this.m.pluginName = pluginName;
            return this;
        }

        @Override
        public ClusterTemplateBuilder hadoopVersion(String hadoopVersion) {
            this.m.hadoopVersion = hadoopVersion;
            return this;
        }

        @Override
        public ClusterTemplateBuilder addNodeGroup(NodeGroup nodeGroup) {
            if (this.m.nodeGroups == null) {
                this.m.nodeGroups = Lists.newArrayList();
            }
            this.m.nodeGroups.add((MapReduceNodeGroup)nodeGroup);
            return this;
        }

        @Override
        public ClusterTemplateBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public ClusterTemplateBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public ClusterTemplateBuilder managementNetworkId(String networkId) {
            this.m.managementNetworkId = networkId;
            return this;
        }

        @Override
        public ClusterTemplateBuilder addServiceConfig(String name, ServiceConfig config) {
            if (name != null && !name.isEmpty()) {
                if (this.m.clusterConfigs == null) {
                    this.m.clusterConfigs = new HashMap();
                }
                this.m.clusterConfigs.put(name, (MapReduceServiceConfig)config);
            }
            return this;
        }
    }

    public static class ClusterTemplates
    extends ListResult<MapReduceClusterTemplate> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="cluster_templates")
        private List<MapReduceClusterTemplate> nodeGroupTemplates;

        @Override
        protected List<MapReduceClusterTemplate> value() {
            return this.nodeGroupTemplates;
        }
    }
}

