/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.map.reduce.DataSource;
import com.huawei.openstack4j.model.map.reduce.DataSourceCredentials;
import com.huawei.openstack4j.model.map.reduce.builder.DataSourceBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceDataSourceCredentials;
import java.util.Date;
import java.util.List;

@JsonRootName(value="data_source")
@JsonIgnoreProperties(ignoreUnknown=true)
public class MapReduceDataSource
implements DataSource {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss")
    private Date updatedAt;
    @JsonProperty(value="type")
    private DataSource.DataSourceType type;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    private MapReduceDataSourceCredentials credentials;
    @JsonProperty(value="is_protected")
    Boolean isProtected;
    @JsonProperty(value="is_public")
    Boolean isPublic;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public DataSource.DataSourceType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSourceCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="is_protected")
    public Boolean isProtected() {
        return this.isProtected;
    }

    @Override
    @JsonProperty(value="is_public")
    public Boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public DataSourceBuilder toBuilder() {
        return new ConcreteDataSourceBuilder(this);
    }

    public static DataSourceBuilder builder() {
        return new ConcreteDataSourceBuilder();
    }

    public String toString() {
        return "MapReduceDataSource(description=" + this.getDescription() + ", url=" + this.getURL() + ", tenantId=" + this.getTenantId() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", name=" + this.getName() + ", credentials=" + this.getCredentials() + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + ")";
    }

    public static class ConcreteDataSourceBuilder
    implements DataSourceBuilder {
        MapReduceDataSource m;

        ConcreteDataSourceBuilder() {
            this(new MapReduceDataSource());
        }

        ConcreteDataSourceBuilder(MapReduceDataSource m) {
            this.m = m;
        }

        @Override
        public DataSourceBuilder id(String dataSourceId) {
            this.m.id = dataSourceId;
            return this;
        }

        @Override
        public DataSourceBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public DataSourceBuilder url(String url) {
            this.m.url = url;
            return this;
        }

        @Override
        public DataSourceBuilder type(DataSource.DataSourceType type) {
            this.m.type = type;
            return this;
        }

        @Override
        public DataSourceBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public DataSourceBuilder isPublic(boolean isPublic) {
            this.m.isPublic = isPublic;
            return this;
        }

        @Override
        public DataSourceBuilder isProtect(boolean isProtected) {
            this.m.isProtected = isProtected;
            return this;
        }

        @Override
        public DataSourceBuilder credentials(String user, String password) {
            this.m.credentials = new MapReduceDataSourceCredentials(user, password);
            return this;
        }

        @Override
        public DataSource build() {
            return this.m;
        }

        @Override
        public DataSourceBuilder from(DataSource in) {
            this.m = (MapReduceDataSource)in;
            return this;
        }
    }

    public static class DataSources
    extends ListResult<MapReduceDataSource> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="data_sources")
        private List<MapReduceDataSource> datasources;

        @Override
        public List<MapReduceDataSource> value() {
            return this.datasources;
        }
    }
}

