/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.api.map.reduce.ClusterService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.map.reduce.Cluster;
import com.huawei.openstack4j.model.map.reduce.NodeGroup;
import com.huawei.openstack4j.openstack.map.reduce.domain.ClusterScalingReq;
import com.huawei.openstack4j.openstack.map.reduce.domain.ListClustersResp;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceCluster;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceClusterCreate;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceClusterCreateResult;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceClusterInfo;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceClusterUnwrapped;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobExeCreate;
import com.huawei.openstack4j.openstack.map.reduce.domain.actions.MapReduceActions;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClusterServiceImpl
extends BaseMapReduceServices
implements ClusterService {
    @Override
    public MapReduceClusterInfo get(String clusterId) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)clusterId) ? 1 : 0), (Object)"parameter `clusterId` should not be null");
        return this.get(MapReduceClusterInfo.class, this.uri("/cluster_infos/%s", clusterId)).execute();
    }

    @Override
    public MapReduceClusterCreateResult createAndRunJob(MapReduceClusterCreate cluster, MapReduceJobExeCreate jobExe) {
        Preconditions.checkNotNull((Object)cluster, (Object)"parameter `cluster` should not be null");
        ArrayList jobs = jobExe == null ? new ArrayList() : Lists.newArrayList((Object[])new MapReduceJobExeCreate[]{jobExe});
        MapReduceClusterCreate create = cluster.toBuilder().jobs(jobs).build();
        return this.post(MapReduceClusterCreateResult.class, "/run-job-flow").entity(create).execute();
    }

    @Override
    public ListClustersResp list(Integer pageSize, Integer currentPage, String clusterName, String clusterState, String tags) {
        HashMap parameters = Maps.newHashMap();
        parameters.put("pageSize", pageSize);
        parameters.put("currentPage", currentPage);
        parameters.put("clusterName", clusterName);
        parameters.put("clusterState", clusterState);
        parameters.put("tags", tags);
        return this.get(ListClustersResp.class, this.uri("/cluster_infos", new Object[0])).params(parameters).execute();
    }

    @Override
    public Cluster create(Cluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        MapReduceClusterUnwrapped unwrapped = new MapReduceClusterUnwrapped(cluster);
        return this.post(MapReduceCluster.class, this.uri("/clusters", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String clusterId) {
        Preconditions.checkNotNull((Object)clusterId);
        return this.deleteWithResponse(this.uri("/clusters/%s", clusterId)).execute();
    }

    @Override
    public ActionResponse resizeNodeGroup(String clusterId, ClusterScalingReq clusterScalingReq) {
        Preconditions.checkNotNull((Object)clusterId);
        return this.putWithResponse(this.uri("/cluster_infos/%s", clusterId)).entity(clusterScalingReq).execute();
    }

    @Override
    public Cluster addNodeGroup(String clusterId, NodeGroup nodeGroup) {
        Preconditions.checkNotNull((Object)clusterId);
        Preconditions.checkNotNull((Object)nodeGroup);
        return this.put(MapReduceCluster.class, this.uri("/clusters/%s", clusterId)).entity(new MapReduceActions.AddNodeGroupAction(nodeGroup)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse expand(String clusterId, int amount) {
        Preconditions.checkNotNull((Object)clusterId, (Object)"the `clusterId` parameter should not be null");
        Preconditions.checkState((amount > 0 ? 1 : 0) != 0, (Object)"the `amount` parameter should be greater than zero");
        ScaleClusterAction expand = ScaleClusterAction.create().expand(amount);
        return this.putWithResponse(this.uri("/cluster_infos/%s", clusterId)).entity(expand).execute();
    }

    @Override
    public ActionResponse reduce(String clusterId, int amount, List<String> includes, List<String> excludes) {
        Preconditions.checkNotNull((Object)clusterId, (Object)"the `clusterId` parameter should not be null");
        Preconditions.checkState((amount > 0 ? 1 : 0) != 0, (Object)"the `amount` parameter should be greater than zero");
        ScaleClusterAction reduce = ScaleClusterAction.create().reduce(amount).includes(includes).excludes(excludes);
        return this.putWithResponse(this.uri("/cluster_infos/%s", clusterId)).entity(reduce).execute();
    }

    private static class ScaleClusterAction {
        @JsonProperty(value="service_id")
        String serviceId = "";
        @JsonProperty(value="plan_id")
        String planId = "";
        @JsonProperty(value="parameters")
        HashMap<String, Object> parameters = Maps.newHashMap();
        @JsonProperty(value="previous_values")
        HashMap<String, Object> previousValues = Maps.newHashMap();
        @JsonIgnore
        ArrayList<String> includes = Lists.newArrayList();
        @JsonIgnore
        ArrayList<String> excludes = Lists.newArrayList();

        public ScaleClusterAction() {
            this.previousValues.put("plan_id", "");
            this.parameters.put("order_id", "");
            this.parameters.put("node_id", "node_orderadd");
            this.parameters.put("include_instances", this.includes);
            this.parameters.put("exclude_instances", this.excludes);
        }

        public static ScaleClusterAction create() {
            return new ScaleClusterAction();
        }

        public ScaleClusterAction expand(int amount) {
            this.parameters.put("instances", amount);
            this.parameters.put("scale_type", "scale_out");
            return this;
        }

        public ScaleClusterAction reduce(int amount) {
            this.parameters.put("instances", amount);
            this.parameters.put("scale_type", "scale_in");
            return this;
        }

        public ScaleClusterAction includes(List<String> instanceIds) {
            if (instanceIds != null && instanceIds.size() > 0) {
                this.includes.addAll(instanceIds);
            }
            return this;
        }

        public ScaleClusterAction excludes(List<String> instanceIds) {
            if (instanceIds != null && instanceIds.size() > 0) {
                this.excludes.addAll(instanceIds);
            }
            return this;
        }
    }
}

