/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.map.reduce.ClusterTemplateService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.map.reduce.ClusterTemplate;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceClusterTemplate;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceClusterTemplateUnwrapped;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.util.List;

public class ClusterTemplateServiceImpl
extends BaseMapReduceServices
implements ClusterTemplateService {
    @Override
    public List<? extends ClusterTemplate> list() {
        return this.get(MapReduceClusterTemplate.ClusterTemplates.class, this.uri("/cluster-templates", new Object[0])).execute().getList();
    }

    @Override
    public ClusterTemplate get(String templateId) {
        Preconditions.checkNotNull((Object)templateId);
        return this.get(MapReduceClusterTemplate.class, this.uri("/cluster-templates/%s", templateId)).execute();
    }

    @Override
    public ClusterTemplate create(ClusterTemplate template) {
        Preconditions.checkNotNull((Object)template);
        MapReduceClusterTemplateUnwrapped unwrapped = new MapReduceClusterTemplateUnwrapped(template);
        return this.post(MapReduceClusterTemplate.class, this.uri("/cluster-templates", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String templateId) {
        Preconditions.checkNotNull((Object)templateId);
        return this.deleteWithResponse(this.uri("/cluster-templates/%s", templateId)).execute();
    }
}

