/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.map.reduce.DataSourceService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.map.reduce.DataSource;
import com.huawei.openstack4j.model.map.reduce.options.DataSourceListOptions;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceDataSource;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceDataSourceUnwrapped;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.util.List;
import java.util.Map;

public class DataSourceServiceImpl
extends BaseMapReduceServices
implements DataSourceService {
    @Override
    public List<? extends DataSource> list(DataSourceListOptions options) {
        Map<String, Object> params = options == null ? null : options.getOptions();
        return this.get(MapReduceDataSource.DataSources.class, this.uri("/data-sources", new Object[0])).params(params).execute().getList();
    }

    @Override
    public DataSource get(String datasourceId) {
        Preconditions.checkNotNull((Object)datasourceId);
        return this.get(MapReduceDataSource.class, this.uri("/data-sources/%s", datasourceId)).execute();
    }

    @Override
    public DataSource create(DataSource datasource) {
        Preconditions.checkNotNull((Object)datasource);
        MapReduceDataSourceUnwrapped unwrapped = new MapReduceDataSourceUnwrapped(datasource);
        return this.post(MapReduceDataSource.class, this.uri("/data-sources", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String datasourceId) {
        Preconditions.checkNotNull((Object)datasourceId);
        return this.deleteWithResponse(this.uri("/data-sources/%s", datasourceId)).execute();
    }

    @Override
    public DataSource update(DataSource datasource) {
        Preconditions.checkNotNull((Object)datasource);
        Preconditions.checkNotNull((Object)datasource.getId(), (Object)"data-source `id` attribute is required");
        Preconditions.checkNotNull((Object)((Object)datasource.getType()), (Object)"data-source `type` attribute is required");
        Preconditions.checkNotNull((Object)datasource.getURL(), (Object)"data-source `URL` attribute is required");
        MapReduceDataSourceUnwrapped unwrapped = new MapReduceDataSourceUnwrapped(datasource);
        return this.put(MapReduceDataSource.class, this.uri("/data-sources/%s", datasource.getId())).entity(unwrapped).execute();
    }
}

