/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.map.reduce.JobBinaryService;
import com.huawei.openstack4j.core.transport.HttpEntityHandler;
import com.huawei.openstack4j.core.transport.HttpResponse;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.common.Payload;
import com.huawei.openstack4j.model.common.Payloads;
import com.huawei.openstack4j.model.map.reduce.JobBinary;
import com.huawei.openstack4j.model.map.reduce.options.JobBinaryListOptions;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobBinary;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobBinaryUnwrapped;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class JobBinaryServiceImpl
extends BaseMapReduceServices
implements JobBinaryService {
    @Override
    public List<? extends JobBinary> list(JobBinaryListOptions options) {
        Map<String, Object> params = options == null ? null : options.getOptions();
        return this.get(MapReduceJobBinary.JobBinaries.class, this.uri("/job-binaries", new Object[0])).params(params).execute().getList();
    }

    @Override
    public JobBinary get(String JobBinaryId) {
        Preconditions.checkNotNull((Object)JobBinaryId);
        return this.get(MapReduceJobBinary.class, this.uri("/job-binaries/%s", JobBinaryId)).execute();
    }

    @Override
    public JobBinary create(JobBinary jobBinary) {
        Preconditions.checkNotNull((Object)jobBinary);
        MapReduceJobBinaryUnwrapped unwrapped = new MapReduceJobBinaryUnwrapped(jobBinary);
        return this.post(MapReduceJobBinary.class, this.uri("/job-binaries", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public JobBinary update(JobBinary jobBinary) {
        Preconditions.checkNotNull((Object)jobBinary);
        Preconditions.checkNotNull((Object)jobBinary.getId(), (Object)"job-binary `id` attribute is required");
        Preconditions.checkNotNull((Object)jobBinary.getURL(), (Object)"job-binary `URL` attribute is required");
        Preconditions.checkNotNull((Object)jobBinary.getName(), (Object)"job-binary `name` attribute is required");
        MapReduceJobBinaryUnwrapped unwrapped = new MapReduceJobBinaryUnwrapped(jobBinary);
        return this.put(MapReduceJobBinary.class, this.uri("/job-binaries/%s", jobBinary.getId())).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String JobBinaryId) {
        Preconditions.checkNotNull((Object)JobBinaryId);
        return this.deleteWithResponse(this.uri("/job-binaries/%s", JobBinaryId)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Payload<InputStream> getData(String JobBinaryId) {
        HttpResponse response = this.get(Void.class, this.uri("/job-binaries/%s/data", JobBinaryId)).executeWithResponse();
        try {
            if (response.getStatus() < 400) {
                Payload<InputStream> payload = Payloads.create(response.getInputStream());
                return payload;
            }
            Payload<InputStream> payload = null;
            return payload;
        }
        finally {
            HttpEntityHandler.closeQuietly(response);
        }
    }
}

