/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.map.reduce.JobExecutionService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.map.reduce.JobExecution;
import com.huawei.openstack4j.model.map.reduce.options.JobExecutionListOptions;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobExecution;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobExecutionUnwrapped;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.util.List;
import java.util.Map;

public class JobExecutionServiceImpl
extends BaseMapReduceServices
implements JobExecutionService {
    @Override
    public JobExecution create(JobExecution jobExecution) {
        Preconditions.checkNotNull((Object)jobExecution);
        MapReduceJobExecutionUnwrapped unwrapped = new MapReduceJobExecutionUnwrapped(jobExecution);
        return this.post(MapReduceJobExecution.class, this.uri("/jobs/%s/execute", jobExecution.getJobIdForExecution())).entity(unwrapped).execute();
    }

    @Override
    public List<? extends JobExecution> list(JobExecutionListOptions options) {
        Map<String, Object> params = options == null ? null : options.getOptions();
        return this.get(MapReduceJobExecution.JobExecutions.class, this.uri("/job-executions", new Object[0])).params(params).execute().getList();
    }

    @Override
    public JobExecution get(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.get(MapReduceJobExecution.class, this.uri("/job-executions/%s", jobExecutionId)).execute();
    }

    @Override
    public JobExecution refreshStatus(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.get(MapReduceJobExecution.class, this.uri("/job-executions/%s/refresh-status", jobExecutionId)).execute();
    }

    @Override
    public JobExecution cancel(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.get(MapReduceJobExecution.class, this.uri("/job-executions/%s/cancel", jobExecutionId)).execute();
    }

    @Override
    public ActionResponse delete(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.deleteWithResponse(this.uri("/job-executions/%s", jobExecutionId)).execute();
    }
}

