/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.map.reduce.JobService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.map.reduce.Job;
import com.huawei.openstack4j.model.map.reduce.JobConfigHint;
import com.huawei.openstack4j.model.map.reduce.options.JobListOptions;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJob;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobConfigHint;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceJobUnwrapped;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.util.List;
import java.util.Map;

public class JobServiceImpl
extends BaseMapReduceServices
implements JobService {
    @Override
    public List<? extends Job> list(JobListOptions options) {
        Map<String, Object> params = options == null ? null : options.getOptions();
        return this.get(MapReduceJob.Jobs.class, this.uri("/jobs", new Object[0])).params(params).execute().getList();
    }

    @Override
    public Job get(String JobId) {
        Preconditions.checkNotNull((Object)JobId);
        return this.get(MapReduceJob.class, this.uri("/jobs/%s", JobId)).execute();
    }

    @Override
    public Job create(Job job) {
        Preconditions.checkNotNull((Object)job);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)job.getName()) ? 1 : 0) != 0, (Object)"job `name` attribute is required");
        Preconditions.checkNotNull((Object)((Object)job.getType()), (Object)"job `type` attribute is required");
        MapReduceJobUnwrapped unwrapped = new MapReduceJobUnwrapped(job);
        return this.post(MapReduceJob.class, this.uri("/jobs", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public Job update(Job job) {
        Preconditions.checkNotNull((Object)job);
        Preconditions.checkNotNull((Object)job.getId(), (Object)"job `id` attribute is required");
        Preconditions.checkNotNull((Object)job.getDescription(), (Object)"job `description` attribute is required");
        MapReduceJobUnwrapped unwrapped = new MapReduceJobUnwrapped(job);
        return this.patch(MapReduceJob.class, this.uri("/jobs/%s", job.getId())).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String JobId) {
        Preconditions.checkNotNull((Object)JobId);
        return this.deleteWithResponse(this.uri("/jobs/%s", JobId)).execute();
    }

    @Override
    public JobConfigHint getConfigHint(String type) {
        Preconditions.checkNotNull((Object)type);
        return this.get(MapReduceJobConfigHint.class, this.uri("/jobs/config-hints/%s", type)).execute();
    }
}

