/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.map.reduce.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.map.reduce.MapReduceImageService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.map.reduce.Image;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.map.reduce.domain.MapReduceImage;
import com.huawei.openstack4j.openstack.map.reduce.internal.BaseMapReduceServices;
import java.util.List;

public class MapReduceImageServiceImpl
extends BaseMapReduceServices
implements MapReduceImageService {
    @Override
    public List<? extends Image> list() {
        return this.get(MapReduceImage.MapReduceImages.class, this.uri("/images", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Image> list(String ... tags) {
        BaseOpenStackService.Invocation<MapReduceImage.MapReduceImages> invoke = this.get(MapReduceImage.MapReduceImages.class, this.uri("/images", new Object[0]));
        for (String tag : tags) {
            invoke = invoke.param("tags", tag);
        }
        return invoke.execute().getList();
    }

    @Override
    public Image get(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.get(MapReduceImage.class, this.uri("/images/%s", imageId)).execute();
    }

    @Override
    public Image register(String imageId, String username, String description) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)username);
        RegisterImageRequest reg = new RegisterImageRequest(username, description);
        return this.post(MapReduceImage.class, this.uri("/images/%s", imageId)).entity(reg).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public ActionResponse unregister(String imageId) {
        Preconditions.checkNotNull((Object)imageId);
        return this.deleteWithResponse(this.uri("/images/%s", imageId)).execute();
    }

    @Override
    public Image tag(String imageId, String ... tags) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)tags);
        return this.post(MapReduceImage.class, this.uri("/images/%s/tag", imageId)).entity(new UpdateTagsRequest(tags)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public Image untag(String imageId, String ... tags) {
        Preconditions.checkNotNull((Object)imageId);
        Preconditions.checkNotNull((Object)tags);
        return this.post(MapReduceImage.class, this.uri("/images/%s/untag", imageId)).entity(new UpdateTagsRequest(tags)).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    public class UpdateTagsRequest
    implements ModelEntity {
        public static final long serialVersionUID = 1L;
        private String[] tags;

        public UpdateTagsRequest(String ... tags) {
            this.tags = tags;
        }

        public String[] getTags() {
            return this.tags;
        }
    }

    public class RegisterImageRequest
    implements ModelEntity {
        public static final long serialVersionUID = 1L;
        private String username;
        private String description;

        public RegisterImageRequest(String username, String description) {
            this.username = username;
            this.description = description;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

