/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.notification.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.message.notification.constant.PushFailedPolicy;
import com.huawei.openstack4j.openstack.message.notification.domain.TracableRequest;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;

public class Topic
extends TracableRequest
implements ModelEntity {
    private static final long serialVersionUID = -6764087311133427927L;
    @JsonProperty(value="topic_urn")
    String urn;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="display_name")
    String displayName;
    @JsonProperty(value="push_policy")
    PushFailedPolicy pushPolicy;
    @JsonProperty(value="create_time")
    Date createTime;
    @JsonProperty(value="update_time")
    Date updateTime;

    public static TopicBuilder builder() {
        return new TopicBuilder();
    }

    public TopicBuilder toBuilder() {
        return new TopicBuilder().urn(this.urn).name(this.name).displayName(this.displayName).pushPolicy(this.pushPolicy).createTime(this.createTime).updateTime(this.updateTime);
    }

    public String getUrn() {
        return this.urn;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PushFailedPolicy getPushPolicy() {
        return this.pushPolicy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String toString() {
        return "Topic(urn=" + this.getUrn() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", pushPolicy=" + (Object)((Object)this.getPushPolicy()) + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }

    public Topic() {
    }

    @ConstructorProperties(value={"urn", "name", "displayName", "pushPolicy", "createTime", "updateTime"})
    public Topic(String urn, String name, String displayName, PushFailedPolicy pushPolicy, Date createTime, Date updateTime) {
        this.urn = urn;
        this.name = name;
        this.displayName = displayName;
        this.pushPolicy = pushPolicy;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    public static class TopicBuilder {
        private String urn;
        private String name;
        private String displayName;
        private PushFailedPolicy pushPolicy;
        private Date createTime;
        private Date updateTime;

        TopicBuilder() {
        }

        public TopicBuilder urn(String urn) {
            this.urn = urn;
            return this;
        }

        public TopicBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TopicBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TopicBuilder pushPolicy(PushFailedPolicy pushPolicy) {
            this.pushPolicy = pushPolicy;
            return this;
        }

        public TopicBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public TopicBuilder updateTime(Date updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Topic build() {
            return new Topic(this.urn, this.name, this.displayName, this.pushPolicy, this.createTime, this.updateTime);
        }

        public String toString() {
            return "Topic.TopicBuilder(urn=" + this.urn + ", name=" + this.name + ", displayName=" + this.displayName + ", pushPolicy=" + (Object)((Object)this.pushPolicy) + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ")";
        }
    }

    public static class Topics
    extends ListResult<Topic> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="topics")
        private List<Topic> topics;
        @JsonProperty(value="request_id")
        String requestId;

        @Override
        public List<Topic> value() {
            return this.topics;
        }

        public String getRequestId() {
            return this.requestId;
        }
    }
}

