/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.notification.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.core.transport.ObjectMapperSingleton;
import com.huawei.openstack4j.openstack.message.notification.domain.Message;
import com.huawei.openstack4j.openstack.message.notification.domain.MessageIdResponse;
import com.huawei.openstack4j.openstack.message.notification.domain.StructuredMessage;
import com.huawei.openstack4j.openstack.message.notification.domain.TemplatedMessage;
import com.huawei.openstack4j.openstack.message.notification.internal.BaseNotificationServices;
import java.util.HashMap;

public class MessageService
extends BaseNotificationServices
implements RestService {
    public MessageIdResponse publish(String topicUrn, String subject, String message) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)topicUrn) ? 1 : 0), (Object)"parameter `topicUrn` should not be empty");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)message) ? 1 : 0), (Object)"parameter `message` should not be empty");
        Message msg = Message.builder().subject(subject).message(message).build();
        return this.post(MessageIdResponse.class, this.uri("/notifications/topics/%s/publish", topicUrn)).entity(msg).execute();
    }

    public MessageIdResponse publish(String topicUrn, TemplatedMessage message) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)topicUrn) ? 1 : 0), (Object)"parameter `topicUrn` should not be null");
        Preconditions.checkNotNull((Object)message, (Object)"parameter `message` should not be null");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)message.getMessageTemplateName()) ? 1 : 0), (Object)"parameter `message.messageTemplateName` should not be empty");
        return this.post(MessageIdResponse.class, this.uri("/notifications/topics/%s/publish", topicUrn)).entity(message).execute();
    }

    public MessageIdResponse publish(String topicUrn, StructuredMessage message) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)topicUrn) ? 1 : 0), (Object)"parameter `topicUrn` should not be null");
        Preconditions.checkNotNull((Object)message, (Object)"parameter `message` should not be null");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)message.getDefaultMessage()) ? 1 : 0), (Object)"parameter `message.defaultMessage` should not be empty");
        try {
            String subject = message.getSubject();
            String payload = ObjectMapperSingleton.getContext(StructuredMessage.class).writeValueAsString((Object)message);
            HashMap body = Maps.newHashMap();
            body.put("message_structure", payload);
            if (!Strings.isNullOrEmpty((String)subject)) {
                body.put("subject", subject);
            }
            return this.post(MessageIdResponse.class, this.uri("/notifications/topics/%s/publish", topicUrn)).entity(body).execute();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

