/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.notification.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.openstack.message.notification.constant.TopicAttributeName;
import com.huawei.openstack4j.openstack.message.notification.domain.Topic;
import com.huawei.openstack4j.openstack.message.notification.domain.TopicAttributes;
import com.huawei.openstack4j.openstack.message.notification.domain.TracableRequest;
import com.huawei.openstack4j.openstack.message.notification.internal.BaseNotificationServices;
import java.util.HashMap;
import java.util.List;

public class TopicService
extends BaseNotificationServices
implements RestService {
    public List<? extends Topic> list(Integer limit, Integer offset) {
        return this.get(Topic.Topics.class, this.uri("/notifications/topics", new Object[0])).param("limit", limit).param("offset", offset).execute().getList();
    }

    public Topic get(String topicUrn) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        return this.get(Topic.class, "/notifications/topics/", topicUrn).execute();
    }

    public Topic create(String name, String displayName) {
        Preconditions.checkNotNull((Object)name, (Object)"parameter `name` should not be empty");
        Topic create = Topic.builder().name(name).displayName(displayName).build();
        return this.post(Topic.class, this.uri("/notifications/topics", new Object[0])).entity(create).execute();
    }

    public TracableRequest updateDisplayName(String topicUrn, String displayName) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        Preconditions.checkNotNull((Object)displayName, (Object)"parameter `displayName` should not be empty");
        Topic update = Topic.builder().displayName(displayName).build();
        return this.put(TracableRequest.class, "/notifications/topics/", topicUrn).entity(update).execute();
    }

    public TracableRequest delete(String topicUrn) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        return this.delete(TracableRequest.class, this.uri("/notifications/topics/%s", topicUrn)).execute();
    }

    public TopicAttributes getTopicAttributes(String topicUrn) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        return this.get(TopicAttributes.TopicAttributesUnwapper.class, "/notifications/topics/", topicUrn, "/attributes").execute().getTopicAttributes();
    }

    public String getTopicAttribute(String topicUrn, TopicAttributeName attributeName) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        Preconditions.checkNotNull((Object)((Object)attributeName), (Object)"parameter `attributeName` should not be empty");
        TopicAttributes.TopicAttributesUnwapper unwrapper = this.get(TopicAttributes.TopicAttributesUnwapper.class, "/notifications/topics/", topicUrn, "/attributes").param("attributes_name", attributeName.value()).execute();
        TopicAttributes attributes = unwrapper.getTopicAttributes();
        switch (attributeName) {
            case AccessPolicy: {
                return attributes.getAccessPolicy();
            }
            case Introduction: {
                return attributes.getIntroduction();
            }
            case SMSSignId: {
                return attributes.getSmsSignId();
            }
        }
        return null;
    }

    public TracableRequest updateTopicAttribute(String topicUrn, TopicAttributeName attributeName, String attributeValue) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        Preconditions.checkNotNull((Object)((Object)attributeName), (Object)"parameter `attributeName` should not be empty");
        Preconditions.checkNotNull((Object)attributeValue, (Object)"parameter `attributeValue` should not be empty");
        HashMap body = Maps.newHashMap();
        body.put("value", attributeValue);
        return this.put(TracableRequest.class, this.uri("/notifications/topics/%s/attributes/%s", topicUrn, attributeName.value())).entity(body).execute();
    }

    public TracableRequest deleteTopicAttribute(String topicUrn, TopicAttributeName attributeName) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        Preconditions.checkNotNull((Object)((Object)attributeName), (Object)"parameter `attributeName` should not be empty");
        return this.delete(TracableRequest.class, this.uri("/notifications/topics/%s/attributes/%s", topicUrn, attributeName.value())).execute();
    }

    public TracableRequest deleteTopicAttributes(String topicUrn) {
        Preconditions.checkNotNull((Object)topicUrn, (Object)"parameter `topicUrn` should not be empty");
        return this.delete(TracableRequest.class, this.uri("/notifications/topics/%s/attributes", topicUrn)).execute();
    }
}

