/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.queue.domain;

import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;

public class ConsumeRequest
implements ModelEntity {
    private static final long serialVersionUID = 7130356790775590533L;
    private String queueId;
    private String consumerGroupId;
    private Integer maxMessages;
    private Integer timeWait;

    public static ConsumeRequestBuilder builder() {
        return new ConsumeRequestBuilder();
    }

    public ConsumeRequestBuilder toBuilder() {
        return new ConsumeRequestBuilder().queueId(this.queueId).consumerGroupId(this.consumerGroupId).maxMessages(this.maxMessages).timeWait(this.timeWait);
    }

    public String getQueueId() {
        return this.queueId;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public Integer getMaxMessages() {
        return this.maxMessages;
    }

    public Integer getTimeWait() {
        return this.timeWait;
    }

    public String toString() {
        return "ConsumeRequest(queueId=" + this.getQueueId() + ", consumerGroupId=" + this.getConsumerGroupId() + ", maxMessages=" + this.getMaxMessages() + ", timeWait=" + this.getTimeWait() + ")";
    }

    public ConsumeRequest() {
    }

    @ConstructorProperties(value={"queueId", "consumerGroupId", "maxMessages", "timeWait"})
    public ConsumeRequest(String queueId, String consumerGroupId, Integer maxMessages, Integer timeWait) {
        this.queueId = queueId;
        this.consumerGroupId = consumerGroupId;
        this.maxMessages = maxMessages;
        this.timeWait = timeWait;
    }

    public static class ConsumeRequestBuilder {
        private String queueId;
        private String consumerGroupId;
        private Integer maxMessages;
        private Integer timeWait;

        ConsumeRequestBuilder() {
        }

        public ConsumeRequestBuilder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public ConsumeRequestBuilder consumerGroupId(String consumerGroupId) {
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        public ConsumeRequestBuilder maxMessages(Integer maxMessages) {
            this.maxMessages = maxMessages;
            return this;
        }

        public ConsumeRequestBuilder timeWait(Integer timeWait) {
            this.timeWait = timeWait;
            return this;
        }

        public ConsumeRequest build() {
            return new ConsumeRequest(this.queueId, this.consumerGroupId, this.maxMessages, this.timeWait);
        }

        public String toString() {
            return "ConsumeRequest.ConsumeRequestBuilder(queueId=" + this.queueId + ", consumerGroupId=" + this.consumerGroupId + ", maxMessages=" + this.maxMessages + ", timeWait=" + this.timeWait + ")";
        }
    }
}

