/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.queue.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.message.queue.domain.ConsumerGroup;
import com.huawei.openstack4j.openstack.message.queue.internal.BaseMessageQueueServices;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConsumerGroupService
extends BaseMessageQueueServices
implements RestService {
    public ConsumerGroup create(String queueId, String consumerGroupName) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)queueId) ? 1 : 0), (Object)"parameter `queueId` should not be empty");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)consumerGroupName) ? 1 : 0), (Object)"parameter `consumerGroupName` should not be empty");
        List<ConsumerGroup> create = this.create(queueId, Lists.newArrayList((Object[])new String[]{consumerGroupName}));
        if (create != null && create.size() == 1) {
            return create.get(0);
        }
        return null;
    }

    public List<ConsumerGroup> create(String queueId, List<String> consumerGroupNames) {
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)queueId) ? 1 : 0), (Object)"parameter `queueId` should not be empty");
        boolean isGroupNamesValid = consumerGroupNames != null && consumerGroupNames.size() > 0 && consumerGroupNames.size() <= 3;
        Preconditions.checkState((boolean)isGroupNamesValid, (Object)"parameter `consumerGroupNames` should be a list with 1-3 items");
        ArrayList groups = Lists.newArrayList();
        for (String name : consumerGroupNames) {
            groups.add(ConsumerGroup.builder().name(name).build());
        }
        HashMap entity = Maps.newHashMap();
        entity.put("groups", groups);
        return this.post(ConsumerGroup.ConsumerGroups.class, this.uri("/queues/%s/groups", queueId)).entity(entity).execute().getList();
    }

    public List<ConsumerGroup> list(String queueId) {
        return this.get(ConsumerGroup.ConsumerGroups.class, this.uri("/queues/%s/groups", queueId)).execute().getList();
    }

    public ActionResponse delete(String queueId, String consumerGroupId) {
        Preconditions.checkNotNull((Object)queueId, (Object)"parameter `queueId` should not be empty");
        Preconditions.checkNotNull((Object)queueId, (Object)"parameter `consumerGroupId` should not be empty");
        return this.delete(ActionResponse.class, this.uri("/queues/%s/groups/%s", queueId, consumerGroupId)).execute();
    }
}

