/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.message.queue.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.common.RestService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.message.queue.domain.Queue;
import com.huawei.openstack4j.openstack.message.queue.internal.BaseMessageQueueServices;
import java.util.List;

public class QueueService
extends BaseMessageQueueServices
implements RestService {
    public Queue create(String name, String description) {
        Preconditions.checkNotNull((Object)name, (Object)"parameter `name` should not be empty");
        Queue create = Queue.builder().name(name).description(description).build();
        return this.post(Queue.class, this.uri("/queues", new Object[0])).entity(create).execute();
    }

    public List<? extends Queue> list() {
        return this.get(Queue.Queues.class, this.uri("/queues", new Object[0])).execute().getList();
    }

    public Queue get(String queueId) {
        Preconditions.checkNotNull((Object)queueId, (Object)"parameter `queueId` should not be empty");
        return this.get(Queue.class, "/queues/", queueId).execute();
    }

    public ActionResponse delete(String queueId) {
        Preconditions.checkNotNull((Object)queueId, (Object)"parameter `queueId` should not be empty");
        return this.delete(ActionResponse.class, this.uri("/queues/%s", queueId)).execute();
    }
}

