/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.murano.v1.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.huawei.openstack4j.api.murano.v1.MuranoApplicationService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.murano.v1.domain.Application;
import com.huawei.openstack4j.openstack.common.MapEntity;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.murano.v1.domain.MuranoApplication;
import com.huawei.openstack4j.openstack.murano.v1.internal.BaseMuranoServices;
import com.huawei.openstack4j.openstack.murano.v1.utils.MuranoApplicationUtils;
import java.util.List;
import java.util.Map;

public class MuranoApplicationServiceImpl
extends BaseMuranoServices
implements MuranoApplicationService {
    @Override
    public List<? extends Application> list(String environmentId, String sessionId) {
        BaseOpenStackService.Invocation<MuranoApplication.ApplicationList> invocation = this.get(MuranoApplication.ApplicationList.class, this.uri("/environments/%s/services", environmentId));
        if (sessionId != null) {
            invocation.header("X-Configuration-Session", sessionId);
        }
        return invocation.execute();
    }

    @Override
    public List<? extends Application> list(String environmentId) {
        return this.list(environmentId, null);
    }

    @Override
    public List<? extends Application> get(String environmentId, String path, String sessionId) {
        BaseOpenStackService.Invocation<JsonNode> invocation = this.get(JsonNode.class, this.uri("/environments/%s/services/%s", environmentId, path));
        if (sessionId != null) {
            invocation.header("X-Configuration-Session", sessionId);
        }
        return MuranoApplicationUtils.toApplications(invocation.execute());
    }

    @Override
    public List<? extends Application> get(String environmentId, String path) {
        return this.get(environmentId, path, null);
    }

    @Override
    public Application create(String environmentId, String sessionId, Map<String, Object> data) {
        MapEntity entity = new MapEntity();
        entity.putAll(data);
        BaseOpenStackService.Invocation<MuranoApplication> invocation = this.post(MuranoApplication.class, this.uri("/environments/%s/services//", environmentId)).header("X-Configuration-Session", sessionId).entity(entity);
        return invocation.execute();
    }

    @Override
    public List<? extends Application> create(String environmentId, String sessionId, String jsonString) {
        MuranoApplication.ApplicationList toCreate = MuranoApplicationUtils.toApplications(jsonString);
        BaseOpenStackService.Invocation<MuranoApplication.ApplicationList> invocation = this.post(MuranoApplication.ApplicationList.class, this.uri("/environments/%s/services//", environmentId)).header("X-Configuration-Session", sessionId).entity(toCreate);
        return invocation.execute();
    }

    @Override
    public Application update(String environmentId, String sessionId, Map<String, Object> data) {
        MapEntity entity = new MapEntity();
        entity.putAll(data);
        BaseOpenStackService.Invocation<MuranoApplication> invocation = this.put(MuranoApplication.class, this.uri("/environments/%s/services//", environmentId)).header("X-Configuration-Session", sessionId).entity(entity);
        return invocation.execute();
    }

    @Override
    public List<? extends Application> update(String environmentId, String sessionId, String jsonString) {
        MuranoApplication.ApplicationList toUpdate = MuranoApplicationUtils.toApplications(jsonString);
        BaseOpenStackService.Invocation<MuranoApplication.ApplicationList> invocation = this.put(MuranoApplication.ApplicationList.class, this.uri("/environments/%s/services//", environmentId)).header("X-Configuration-Session", sessionId).entity(toUpdate);
        return invocation.execute();
    }

    @Override
    public ActionResponse delete(String environmentId, String path, String sessionId) {
        return this.deleteWithResponse(this.uri("/environments/%s/services/%s", environmentId, path)).header("X-Configuration-Session", sessionId).execute();
    }
}

