/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.nat.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.nat.NatGateWayService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.nat.domain.NatGateWay;
import com.huawei.openstack4j.openstack.nat.domain.NatGateWayCreate;
import com.huawei.openstack4j.openstack.nat.domain.NatGateWayUpdate;
import com.huawei.openstack4j.openstack.nat.internal.BaseNatServices;
import java.util.List;
import java.util.Map;

public class NatGateWayServiceImpl
extends BaseNatServices
implements NatGateWayService {
    private static final String API_PATH = "/nat_gateways";

    @Override
    public NatGateWay get(String natGateWayId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)natGateWayId) ? 1 : 0) != 0, (Object)"parameter `natGateWayId` should not be empty");
        return this.get(NatGateWay.class, this.uri("/nat_gateways/%s", natGateWayId)).execute();
    }

    @Override
    public List<NatGateWay> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NatGateWay.NatGateWays> req = this.get(NatGateWay.NatGateWays.class, this.uri(API_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public NatGateWay create(NatGateWayCreate natGateWayModel) {
        return this.post(NatGateWay.class, this.uri(API_PATH, new Object[0])).entity(natGateWayModel).execute();
    }

    @Override
    public NatGateWay update(NatGateWayUpdate updateModel, String natGateWayId) {
        Preconditions.checkArgument((null != updateModel ? 1 : 0) != 0, (Object)"parameter `updateModel` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)natGateWayId) ? 1 : 0) != 0, (Object)"parameter `natGateWayId` should not be empty");
        return this.put(NatGateWay.class, this.uri("/nat_gateways/%s", natGateWayId)).entity(updateModel).execute();
    }

    @Override
    public ActionResponse delete(String natGateWayId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)natGateWayId) ? 1 : 0) != 0, (Object)"parameter `natGateWayId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/nat_gateways/%s", natGateWayId)).executeWithResponse());
    }

    @Override
    public List<NatGateWay> list() {
        return this.get(NatGateWay.NatGateWays.class, this.uri(API_PATH, new Object[0])).execute().getList();
    }
}

