/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.common.builder.ResourceBuilder;
import com.huawei.openstack4j.model.network.ExternalGateway;
import com.huawei.openstack4j.model.network.HostRoute;
import com.huawei.openstack4j.model.network.Router;
import com.huawei.openstack4j.model.network.State;
import com.huawei.openstack4j.model.network.builder.RouterBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.networking.domain.NeutronExternalGateway;
import com.huawei.openstack4j.openstack.networking.domain.NeutronHostRoute;
import java.util.List;
import java.util.Objects;

@JsonRootName(value="router")
public class NeutronRouter
implements Router {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="status")
    private State status;
    @JsonProperty(value="external_gateway_info")
    private NeutronExternalGateway externalGatewayInfo;
    @JsonProperty(value="admin_state_up")
    private Boolean adminStateUp;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="routes")
    private List<NeutronHostRoute> routes;
    @JsonProperty(value="distributed")
    private Boolean distributed;

    public static RouterBuilder builder() {
        return new RouterConcreteBuilder();
    }

    @Override
    public RouterBuilder toBuilder() {
        return new RouterConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public List<? extends HostRoute> getRoutes() {
        return this.routes;
    }

    @Override
    @JsonIgnore
    public Boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public State getStatus() {
        return this.status;
    }

    @Override
    public ExternalGateway getExternalGatewayInfo() {
        return this.externalGatewayInfo;
    }

    @Override
    public Boolean getDistributed() {
        return this.distributed;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("tenantId", (Object)this.tenantId).add("admin_state_up", (Object)this.adminStateUp).add("external_gateway_info", (Object)this.externalGatewayInfo).add("routes", this.routes).add("distributed", (Object)this.distributed).addValue((Object)"\n").toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.status, this.tenantId, this.adminStateUp, this.externalGatewayInfo, this.routes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeutronRouter) {
            NeutronRouter that = (NeutronRouter)obj;
            if (Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals((Object)this.status, (Object)that.status) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.adminStateUp, that.adminStateUp) && Objects.equals(this.externalGatewayInfo, that.externalGatewayInfo) && Objects.equals(this.routes, that.routes)) {
                return true;
            }
        }
        return false;
    }

    public static class RouterConcreteBuilder
    extends ResourceBuilder<Router, RouterConcreteBuilder>
    implements RouterBuilder {
        private NeutronRouter m;

        RouterConcreteBuilder() {
            this(new NeutronRouter());
        }

        RouterConcreteBuilder(NeutronRouter m) {
            this.m = m;
        }

        @Override
        public RouterBuilder adminStateUp(Boolean isAdminStateUp) {
            this.m.adminStateUp = isAdminStateUp;
            return this;
        }

        @Override
        public RouterBuilder externalGateway(String networkId) {
            return this.externalGateway(networkId, null);
        }

        @Override
        public RouterBuilder externalGateway(String networkId, Boolean enableSNAT) {
            this.m.externalGatewayInfo = new NeutronExternalGateway(networkId, enableSNAT);
            return this;
        }

        @Override
        public RouterBuilder externalGateway(ExternalGateway externalGateway) {
            this.m.externalGatewayInfo = (NeutronExternalGateway)externalGateway;
            return this;
        }

        @Override
        public RouterBuilder clearExternalGateway() {
            this.m.externalGatewayInfo = new NeutronExternalGateway();
            return this;
        }

        @Override
        public RouterBuilder route(String destination, String nexthop) {
            if (this.m.routes == null) {
                this.m.routes = Lists.newArrayList();
            }
            this.m.routes.add(new NeutronHostRoute(destination, nexthop));
            return this;
        }

        @Override
        public RouterBuilder noRoutes() {
            this.m.routes = Lists.newArrayList();
            return this;
        }

        @Override
        protected Router reference() {
            return this.m;
        }

        @Override
        public Router build() {
            return this.m;
        }

        @Override
        public RouterBuilder from(Router in) {
            this.m = (NeutronRouter)in;
            return this;
        }

        @Override
        public RouterBuilder distributed(Boolean distributed) {
            this.m.distributed = distributed;
            return this;
        }
    }

    public static class Routers
    extends ListResult<NeutronRouter> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="routers")
        private List<NeutronRouter> routers;

        @Override
        protected List<NeutronRouter> value() {
            return this.routers;
        }
    }
}

