/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.network.SecurityGroupRule;
import com.huawei.openstack4j.model.network.builder.NetSecurityGroupRuleBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.util.List;
import java.util.Objects;

@JsonRootName(value="security_group_rule")
public class NeutronSecurityGroupRule
implements SecurityGroupRule {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="security_group_id")
    private String securityGroupId;
    @JsonProperty(value="direction")
    private String direction;
    @JsonProperty(value="ethertype")
    private String etherType;
    @JsonProperty(value="port_range_max")
    private Integer portRangeMax;
    @JsonProperty(value="port_range_min")
    private Integer portRangeMin;
    @JsonProperty(value="protocol")
    private String protocol;
    @JsonProperty(value="remote_ip_prefix")
    private String remoteIpPrefix;
    @JsonProperty(value="remote_group_id")
    private String remoteGroupId;

    @Override
    public NetSecurityGroupRuleBuilder toBuilder() {
        return new SecurityGroupRuleConcreteBuilder(this);
    }

    public static NetSecurityGroupRuleBuilder builder() {
        return new SecurityGroupRuleConcreteBuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getDirection() {
        return this.direction;
    }

    @Override
    public String getEtherType() {
        return this.etherType;
    }

    @Override
    public Integer getPortRangeMax() {
        return this.portRangeMax;
    }

    @Override
    public Integer getPortRangeMin() {
        return this.portRangeMin;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getRemoteGroupId() {
        return this.remoteGroupId;
    }

    @Override
    public String getRemoteIpPrefix() {
        return this.remoteIpPrefix;
    }

    @Override
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("tenantId", (Object)this.tenantId).add("securityGroupId", (Object)this.securityGroupId).add("direction", (Object)this.direction).add("ethertype", (Object)this.etherType).add("portRangeMin", (Object)this.portRangeMin).add("portRangeMax", (Object)this.portRangeMax).add("protocol", (Object)this.protocol).add("remoteGroup", (Object)this.remoteGroupId).add("remoteIpPrefix", (Object)this.remoteIpPrefix).addValue((Object)"\n").toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tenantId, this.securityGroupId, this.direction, this.etherType, this.portRangeMin, this.portRangeMax, this.protocol, this.remoteGroupId, this.remoteIpPrefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeutronSecurityGroupRule) {
            NeutronSecurityGroupRule that = (NeutronSecurityGroupRule)obj;
            if (Objects.equals(this.id, that.id) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.securityGroupId, that.securityGroupId) && Objects.equals(this.direction, that.direction) && Objects.equals(this.etherType, that.etherType) && Objects.equals(this.portRangeMin, that.portRangeMin) && Objects.equals(this.portRangeMax, that.portRangeMax) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.remoteGroupId, that.remoteGroupId) && Objects.equals(this.remoteIpPrefix, that.remoteIpPrefix)) {
                return true;
            }
        }
        return false;
    }

    public static class SecurityGroupRuleConcreteBuilder
    implements NetSecurityGroupRuleBuilder {
        NeutronSecurityGroupRule r;

        public SecurityGroupRuleConcreteBuilder() {
            this.r = new NeutronSecurityGroupRule();
        }

        public SecurityGroupRuleConcreteBuilder(SecurityGroupRule rule) {
            this.r = (NeutronSecurityGroupRule)rule;
        }

        @Override
        public SecurityGroupRule build() {
            return this.r;
        }

        @Override
        public NetSecurityGroupRuleBuilder from(SecurityGroupRule in) {
            this.r = (NeutronSecurityGroupRule)in;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder id(String id) {
            this.r.id = id;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder tenantId(String tenantId) {
            this.r.tenantId = tenantId;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder securityGroupId(String groupId) {
            this.r.securityGroupId = groupId;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder direction(String direction) {
            this.r.direction = direction;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder ethertype(String ethertype) {
            this.r.etherType = ethertype;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder portRangeMax(int max) {
            this.r.portRangeMax = max;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder portRangeMin(int min) {
            this.r.portRangeMin = min;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder protocol(String protocol) {
            this.r.protocol = protocol;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder remoteGroupId(String remoteGroupId) {
            this.r.remoteGroupId = remoteGroupId;
            return this;
        }

        @Override
        public NetSecurityGroupRuleBuilder remoteIpPrefix(String prefix) {
            this.r.remoteIpPrefix = prefix;
            return this;
        }
    }

    public static class SecurityGroupRules
    extends ListResult<NeutronSecurityGroupRule> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="security_group_rules")
        private List<NeutronSecurityGroupRule> rules;

        @Override
        protected List<NeutronSecurityGroupRule> value() {
            return this.rules;
        }
    }
}

