/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="vpnservice")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronVpn
implements ModelEntity {
    private static final long serialVersionUID = 2332364967106563855L;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    @JsonProperty(value="router_id")
    private String routerId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="vpnservice")
    private Object vpnservice;
    @JsonProperty(value="status")
    private Type status;
    @JsonProperty(value="external_v6_ip")
    private String externalV6Ip;
    @JsonProperty(value="external_v4_ip")
    private String externalV4Ip;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="bandwidth")
    private Integer bandwidth;

    public static NeutronVpnBuilder builder() {
        return new NeutronVpnBuilder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getRouterId() {
        return this.routerId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getVpnservice() {
        return this.vpnservice;
    }

    public Type getStatus() {
        return this.status;
    }

    public String getExternalV6Ip() {
        return this.externalV6Ip;
    }

    public String getExternalV4Ip() {
        return this.externalV4Ip;
    }

    public String getId() {
        return this.id;
    }

    public Integer getBandwidth() {
        return this.bandwidth;
    }

    public String toString() {
        return "NeutronVpn(projectId=" + this.getProjectId() + ", subnetId=" + this.getSubnetId() + ", routerId=" + this.getRouterId() + ", name=" + this.getName() + ", adminStateUp=" + this.isAdminStateUp() + ", tenantId=" + this.getTenantId() + ", description=" + this.getDescription() + ", vpnservice=" + this.getVpnservice() + ", status=" + (Object)((Object)this.getStatus()) + ", externalV6Ip=" + this.getExternalV6Ip() + ", externalV4Ip=" + this.getExternalV4Ip() + ", id=" + this.getId() + ", bandwidth=" + this.getBandwidth() + ")";
    }

    public NeutronVpn() {
    }

    @ConstructorProperties(value={"projectId", "subnetId", "routerId", "name", "adminStateUp", "tenantId", "description", "vpnservice", "status", "externalV6Ip", "externalV4Ip", "id", "bandwidth"})
    public NeutronVpn(String projectId, String subnetId, String routerId, String name, boolean adminStateUp, String tenantId, String description, Object vpnservice, Type status, String externalV6Ip, String externalV4Ip, String id, Integer bandwidth) {
        this.projectId = projectId;
        this.subnetId = subnetId;
        this.routerId = routerId;
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.tenantId = tenantId;
        this.description = description;
        this.vpnservice = vpnservice;
        this.status = status;
        this.externalV6Ip = externalV6Ip;
        this.externalV4Ip = externalV4Ip;
        this.id = id;
        this.bandwidth = bandwidth;
    }

    public static class NeutronVpnBuilder {
        private String projectId;
        private String subnetId;
        private String routerId;
        private String name;
        private boolean adminStateUp;
        private String tenantId;
        private String description;
        private Object vpnservice;
        private Type status;
        private String externalV6Ip;
        private String externalV4Ip;
        private String id;
        private Integer bandwidth;

        NeutronVpnBuilder() {
        }

        public NeutronVpnBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public NeutronVpnBuilder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public NeutronVpnBuilder routerId(String routerId) {
            this.routerId = routerId;
            return this;
        }

        public NeutronVpnBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NeutronVpnBuilder adminStateUp(boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this;
        }

        public NeutronVpnBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public NeutronVpnBuilder description(String description) {
            this.description = description;
            return this;
        }

        public NeutronVpnBuilder vpnservice(Object vpnservice) {
            this.vpnservice = vpnservice;
            return this;
        }

        public NeutronVpnBuilder status(Type status) {
            this.status = status;
            return this;
        }

        public NeutronVpnBuilder externalV6Ip(String externalV6Ip) {
            this.externalV6Ip = externalV6Ip;
            return this;
        }

        public NeutronVpnBuilder externalV4Ip(String externalV4Ip) {
            this.externalV4Ip = externalV4Ip;
            return this;
        }

        public NeutronVpnBuilder id(String id) {
            this.id = id;
            return this;
        }

        public NeutronVpnBuilder bandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public NeutronVpn build() {
            return new NeutronVpn(this.projectId, this.subnetId, this.routerId, this.name, this.adminStateUp, this.tenantId, this.description, this.vpnservice, this.status, this.externalV6Ip, this.externalV4Ip, this.id, this.bandwidth);
        }

        public String toString() {
            return "NeutronVpn.NeutronVpnBuilder(projectId=" + this.projectId + ", subnetId=" + this.subnetId + ", routerId=" + this.routerId + ", name=" + this.name + ", adminStateUp=" + this.adminStateUp + ", tenantId=" + this.tenantId + ", description=" + this.description + ", vpnservice=" + this.vpnservice + ", status=" + (Object)((Object)this.status) + ", externalV6Ip=" + this.externalV6Ip + ", externalV4Ip=" + this.externalV4Ip + ", id=" + this.id + ", bandwidth=" + this.bandwidth + ")";
        }
    }

    public static enum Type {
        ACTIVE,
        DOWN,
        BUILD,
        ERROR,
        PENDING_CREATE,
        PENDING_UPDATE,
        PENDING_DELETE;


        @JsonValue
        public String value() {
            return this.name().toUpperCase();
        }

        @JsonCreator
        public static Type value(String v) {
            try {
                return Type.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    public static class NeutronVpns
    extends ListResult<NeutronVpn> {
        private static final long serialVersionUID = 8105209424631380782L;
        @JsonProperty(value="vpnservices")
        private List<NeutronVpn> vpnservices;

        @Override
        protected List<NeutronVpn> value() {
            return this.vpnservices;
        }
    }
}

