/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="endpoint_group")
public class VpnEndpoint
implements ModelEntity {
    private static final long serialVersionUID = -477991724233967198L;
    @JsonProperty
    private List<String> endpoints;
    @JsonProperty
    private EndpointType type;
    @JsonProperty
    private String name;
    @JsonProperty(value="tenantId")
    private String tenant_id;
    @JsonProperty(value="projectId")
    private String project_id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String id;

    public static VpnEndpointBuilder builder() {
        return new VpnEndpointBuilder();
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public EndpointType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getTenant_id() {
        return this.tenant_id;
    }

    public String getProject_id() {
        return this.project_id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "VpnEndpoint(endpoints=" + this.getEndpoints() + ", type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ", tenant_id=" + this.getTenant_id() + ", project_id=" + this.getProject_id() + ", description=" + this.getDescription() + ", id=" + this.getId() + ")";
    }

    public VpnEndpoint() {
    }

    @ConstructorProperties(value={"endpoints", "type", "name", "tenant_id", "project_id", "description", "id"})
    public VpnEndpoint(List<String> endpoints, EndpointType type, String name, String tenant_id, String project_id, String description, String id) {
        this.endpoints = endpoints;
        this.type = type;
        this.name = name;
        this.tenant_id = tenant_id;
        this.project_id = project_id;
        this.description = description;
        this.id = id;
    }

    public static class VpnEndpointBuilder {
        private List<String> endpoints;
        private EndpointType type;
        private String name;
        private String tenant_id;
        private String project_id;
        private String description;
        private String id;

        VpnEndpointBuilder() {
        }

        public VpnEndpointBuilder endpoints(List<String> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public VpnEndpointBuilder type(EndpointType type) {
            this.type = type;
            return this;
        }

        public VpnEndpointBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VpnEndpointBuilder tenant_id(String tenant_id) {
            this.tenant_id = tenant_id;
            return this;
        }

        public VpnEndpointBuilder project_id(String project_id) {
            this.project_id = project_id;
            return this;
        }

        public VpnEndpointBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VpnEndpointBuilder id(String id) {
            this.id = id;
            return this;
        }

        public VpnEndpoint build() {
            return new VpnEndpoint(this.endpoints, this.type, this.name, this.tenant_id, this.project_id, this.description, this.id);
        }

        public String toString() {
            return "VpnEndpoint.VpnEndpointBuilder(endpoints=" + this.endpoints + ", type=" + (Object)((Object)this.type) + ", name=" + this.name + ", tenant_id=" + this.tenant_id + ", project_id=" + this.project_id + ", description=" + this.description + ", id=" + this.id + ")";
        }
    }

    public static enum EndpointType {
        subnet,
        cidr;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static EndpointType value(String v) {
            try {
                return EndpointType.valueOf(v.toLowerCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    public static class VpnEndpoints
    extends ListResult<VpnEndpoint> {
        @JsonProperty(value="endpoint_groups")
        private List<VpnEndpoint> endpointGroups;
        private static final long serialVersionUID = 4981070310993311563L;

        @Override
        protected List<VpnEndpoint> value() {
            return this.endpointGroups;
        }
    }
}

