/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;

public class FirewallRuleStrategy
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="firewall_rule_id")
    private String firewallRuleId;
    @JsonProperty(value="insert_after")
    private String insertAfterRuleId;
    @JsonProperty(value="insert_before")
    private String insertBeforeRuleId;

    public static FirewallRuleStrategy create(String firewallRuleId, RuleInsertStrategyType type, String insertAfterOrBeforeRuleId) {
        FirewallRuleStrategy action = new FirewallRuleStrategy();
        action.firewallRuleId = firewallRuleId;
        if (type == RuleInsertStrategyType.BEFORE) {
            action.insertBeforeRuleId = insertAfterOrBeforeRuleId;
        } else {
            action.insertAfterRuleId = insertAfterOrBeforeRuleId;
        }
        return action;
    }

    public static FirewallRuleStrategy remove(String firewallRuleId) {
        FirewallRuleStrategy action = new FirewallRuleStrategy();
        action.firewallRuleId = firewallRuleId;
        return action;
    }

    @JsonIgnore
    public String getFirewallRuleId() {
        return this.firewallRuleId;
    }

    @JsonIgnore
    public String getInsertAfterRuleId() {
        return this.insertAfterRuleId;
    }

    @JsonIgnore
    public String getInsertBeforeRuleId() {
        return this.insertBeforeRuleId;
    }

    public static enum RuleInsertStrategyType {
        BEFORE,
        AFTER;

    }
}

