/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.network.ext.ListenerProtocol;
import com.huawei.openstack4j.model.network.ext.ListenerV2;
import com.huawei.openstack4j.model.network.ext.builder.ListenerV2Builder;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.networking.domain.ext.ListItem;
import java.util.List;

@JsonRootName(value="listener")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronListenerV2
implements ListenerV2 {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String name;
    private String description;
    private ListenerProtocol protocol;
    @JsonProperty(value="protocol_port")
    private Integer protocolPort;
    @JsonProperty(value="connection_limit")
    private Integer connectionLimit;
    @JsonProperty(value="default_pool_id")
    private String defaultPoolId;
    @JsonProperty(value="loadbalancer_id")
    private String loadbalancerId;
    @JsonProperty(value="loadbalancers")
    private List<ListItem> loadbalancers;
    @JsonProperty(value="admin_state_up")
    private Boolean adminStateUp = true;
    @JsonProperty(value="default_tls_container_ref")
    private String defaultTlsContainerRef;
    @JsonProperty(value="sni_container_refs")
    private List<String> sniContainerRefs;
    @JsonProperty(value="client_ca_tls_container_ref")
    private String clientTlsContainerRef;

    @Override
    public List<ListItem> getLoadBalancers() {
        return this.loadbalancers;
    }

    @Override
    public Boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public String getDefaultPoolId() {
        return this.defaultPoolId;
    }

    @Override
    public Integer getConnectionLimit() {
        return this.connectionLimit;
    }

    @Override
    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    @Override
    public ListenerProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getDefaultTlsContainerRef() {
        return this.defaultTlsContainerRef;
    }

    @Override
    public List<String> getSniContainerRefs() {
        return this.sniContainerRefs;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getclientTlsContainerRef() {
        return this.clientTlsContainerRef;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("adminStateUp", (Object)this.adminStateUp).add("tenantId", (Object)this.tenantId).add("description", (Object)this.description).add("loadbalancers", this.loadbalancers).add("name", (Object)this.name).add("protocol", (Object)this.protocol).add("protocolPort", (Object)this.protocolPort).add("connectionLImit", (Object)this.connectionLimit).add("defaultPoolId", (Object)this.defaultPoolId).add("defaultTlsContainerRef", (Object)this.defaultTlsContainerRef).add("sniContainerRefs", this.sniContainerRefs).add("clientTlsContainerRef", (Object)this.clientTlsContainerRef).toString();
    }

    @Override
    public ListenerV2Builder toBuilder() {
        return new ListenerConcreteBuilder(this);
    }

    public static ListenerV2Builder builder() {
        return new ListenerConcreteBuilder();
    }

    public static class Listeners
    extends ListResult<NeutronListenerV2> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="listeners")
        List<NeutronListenerV2> listeners;

        @Override
        protected List<NeutronListenerV2> value() {
            return this.listeners;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("listeners", this.listeners).toString();
        }
    }

    public static class ListenerConcreteBuilder
    implements ListenerV2Builder {
        private NeutronListenerV2 m;

        public ListenerConcreteBuilder() {
            this(new NeutronListenerV2());
        }

        public ListenerConcreteBuilder(NeutronListenerV2 m) {
            this.m = m;
        }

        @Override
        public ListenerV2 build() {
            return this.m;
        }

        @Override
        public ListenerV2Builder from(ListenerV2 in) {
            this.m = (NeutronListenerV2)in;
            return this;
        }

        @Override
        public ListenerV2Builder loadBalancerId(String loadbalancerId) {
            this.m.loadbalancerId = loadbalancerId;
            return this;
        }

        @Override
        public ListenerV2Builder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public ListenerV2Builder protocol(ListenerProtocol protocol) {
            this.m.protocol = protocol;
            return this;
        }

        @Override
        public ListenerV2Builder protocolPort(Integer protocolPort) {
            this.m.protocolPort = protocolPort;
            return this;
        }

        @Override
        public ListenerV2Builder adminStateUp(Boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public ListenerV2Builder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public ListenerV2Builder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public ListenerV2Builder connectionLimit(Integer connectionLimit) {
            this.m.connectionLimit = connectionLimit;
            return this;
        }

        @Override
        public ListenerV2Builder sniContainerRefs(List<String> sniContainerRefs) {
            this.m.sniContainerRefs = sniContainerRefs;
            return this;
        }

        @Override
        public ListenerV2Builder defaultTlsContainerRef(String tlsContainerRef) {
            this.m.defaultTlsContainerRef = tlsContainerRef;
            return this;
        }

        @Override
        public ListenerV2Builder clientTlsContainerRef(String clientTlsContainerRef) {
            this.m.clientTlsContainerRef = clientTlsContainerRef;
            return this;
        }
    }
}

