/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.NetFloatingIPService;
import com.huawei.openstack4j.core.transport.ExecutionOptions;
import com.huawei.openstack4j.core.transport.propagation.PropagateOnStatus;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.NetFloatingIP;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.NeutronFloatingIP;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class FloatingIPServiceImpl
extends BaseNetworkingServices
implements NetFloatingIPService {
    @Override
    public List<? extends NetFloatingIP> list() {
        return this.get(NeutronFloatingIP.FloatingIPs.class, this.uri("/floatingips", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends NetFloatingIP> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronFloatingIP.FloatingIPs> fIPsInvocation = this.get(NeutronFloatingIP.FloatingIPs.class, "/floatingips");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                fIPsInvocation = fIPsInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return fIPsInvocation.execute().getList();
    }

    @Override
    public NetFloatingIP get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(NeutronFloatingIP.class, this.uri("/floatingips/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/floatingips/%s", id)).execute();
    }

    @Override
    public NetFloatingIP create(NetFloatingIP floatingIp) {
        Preconditions.checkNotNull((Object)floatingIp);
        Preconditions.checkNotNull((Object)floatingIp.getFloatingNetworkId());
        return this.post(NeutronFloatingIP.class, this.uri("/floatingips", new Object[0])).entity(floatingIp).execute();
    }

    @Override
    public NetFloatingIP associateToPort(String id, String portId) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)portId);
        String inner = String.format("{ \"port_id\":\"%s\" }", portId);
        String json = String.format("{ \"%s\": %s }", "floatingip", inner);
        return this.put(NeutronFloatingIP.class, this.uri("/floatingips/%s", id)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public NetFloatingIP disassociateFromPort(String id) {
        Preconditions.checkNotNull((Object)id);
        String json = String.format("{ \"%s\": %s }", "floatingip", "{ \"port_id\":null }");
        return this.put(NeutronFloatingIP.class, this.uri("/floatingips/%s", id)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

