/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.IkePolicyService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.networking.domain.IKEPolicy;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class IkePolicyServiceImpl
extends BaseNetworkingServices
implements IkePolicyService {
    private static final String API_PATH = "/vpn/ikepolicies";
    private static final String filter = "fields";

    @Override
    public IKEPolicy create(IKEPolicy model) {
        return this.post(IKEPolicy.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public List<IKEPolicy> list(String field) {
        return this.get(IKEPolicy.IKEPolicies.class, this.uri(API_PATH, new Object[0])).param(filter, field).execute().getList();
    }

    @Override
    public IKEPolicy get(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `id` should not be empty");
        return this.get(IKEPolicy.class, this.uri("/vpn/ikepolicies/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `id` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vpn/ikepolicies/%s", id)).executeWithResponse());
    }

    @Override
    public IKEPolicy update(String id, IKEPolicy model) {
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `model` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)id) ? 1 : 0) != 0, (Object)"parameter `id` should not be empty");
        return this.put(IKEPolicy.class, this.uri("/vpn/ikepolicies/%s", id)).entity(model).execute();
    }
}

