/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.networking.ext.IpsecConnectionService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.networking.domain.NeutronIpsecConnection;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;

public class IpsecConnectionServiceImpl
extends BaseNetworkingServices
implements IpsecConnectionService {
    private static final String API_PATH = "/vpn/ipsec-site-connections";
    private static final String filter = "fields";

    @Override
    public NeutronIpsecConnection create(NeutronIpsecConnection model) {
        return this.post(NeutronIpsecConnection.class, this.uri(API_PATH, new Object[0])).entity(model).execute();
    }

    @Override
    public List<NeutronIpsecConnection> list(String field) {
        return this.get(NeutronIpsecConnection.NeutronIpsecConnections.class, this.uri(API_PATH, new Object[0])).param(filter, field).execute().getList();
    }

    @Override
    public NeutronIpsecConnection get(String connectionId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connectionId) ? 1 : 0) != 0, (Object)"parameter `connectionId` should not be empty");
        return this.get(NeutronIpsecConnection.class, this.uri("/vpn/ipsec-site-connections/%s", connectionId)).execute();
    }

    @Override
    public ActionResponse delete(String connectionId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connectionId) ? 1 : 0) != 0, (Object)"parameter `connectionId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/vpn/ipsec-site-connections/%s", connectionId)).executeWithResponse());
    }

    @Override
    public NeutronIpsecConnection update(String connectionId, NeutronIpsecConnection model) {
        Preconditions.checkArgument((null != model ? 1 : 0) != 0, (Object)"parameter `model` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connectionId) ? 1 : 0) != 0, (Object)"parameter `connectionId` should not be empty");
        return this.put(NeutronIpsecConnection.class, this.uri("/vpn/ipsec-site-connections/%s", connectionId)).entity(model).execute();
    }
}

