/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.SecurityGroupRuleService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.SecurityGroupRule;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.NeutronSecurityGroupRule;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class SecurityGroupRuleServiceImpl
extends BaseNetworkingServices
implements SecurityGroupRuleService {
    @Override
    public SecurityGroupRule get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(NeutronSecurityGroupRule.class, this.uri("/security-group-rules/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String ruleId) {
        Preconditions.checkNotNull((Object)ruleId);
        return this.deleteWithResponse(this.uri("/security-group-rules/%s", ruleId)).execute();
    }

    @Override
    public SecurityGroupRule create(SecurityGroupRule rule) {
        Preconditions.checkNotNull((Object)rule);
        return this.post(NeutronSecurityGroupRule.class, this.uri("/security-group-rules", new Object[0])).entity(rule).execute();
    }

    @Override
    public List<? extends SecurityGroupRule> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronSecurityGroupRule.SecurityGroupRules> securityGroupRulesInvocation = this.get(NeutronSecurityGroupRule.SecurityGroupRules.class, "/security-group-rules");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                securityGroupRulesInvocation = securityGroupRulesInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return securityGroupRulesInvocation.execute().getList();
    }

    @Override
    public List<? extends SecurityGroupRule> list() {
        return this.get(NeutronSecurityGroupRule.SecurityGroupRules.class, this.uri("/security-group-rules", new Object[0])).execute().getList();
    }
}

