/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.networking.SubnetService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.network.Subnet;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.domain.NeutronSubnet;
import com.huawei.openstack4j.openstack.networking.domain.NeutronSubnetUpdate;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class SubnetServiceImpl
extends BaseNetworkingServices
implements SubnetService {
    @Override
    public List<? extends Subnet> list() {
        return this.get(NeutronSubnet.Subnets.class, this.uri("/subnets", new Object[0])).execute().getList();
    }

    @Override
    public Subnet get(String subnetId) {
        Preconditions.checkNotNull((Object)subnetId);
        return this.get(NeutronSubnet.class, this.uri("/subnets/%s", subnetId)).execute();
    }

    @Override
    public ActionResponse delete(String subnetId) {
        Preconditions.checkNotNull((Object)subnetId);
        return this.deleteWithResponse(this.uri("/subnets/%s", subnetId)).execute();
    }

    @Override
    public Subnet create(Subnet subnet) {
        Preconditions.checkNotNull((Object)subnet);
        return this.post(NeutronSubnet.class, this.uri("/subnets", new Object[0])).entity(subnet).execute();
    }

    @Override
    public Subnet update(Subnet subnet) {
        Preconditions.checkNotNull((Object)subnet);
        return this.update(subnet.getId(), subnet);
    }

    @Override
    public Subnet update(String subnetId, Subnet subnet) {
        Preconditions.checkNotNull((Object)subnetId);
        Preconditions.checkNotNull((Object)subnet);
        return this.put(NeutronSubnet.class, this.uri("/subnets/%s", subnetId)).entity(NeutronSubnetUpdate.createFromSubnet(subnet)).execute();
    }

    @Override
    public List<? extends Subnet> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronSubnet.Subnets> subnetsInvocation = this.get(NeutronSubnet.Subnets.class, "/subnets");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                subnetsInvocation = subnetsInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return subnetsInvocation.execute().getList();
    }
}

